/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.FormatSchema;
import com.github.erosb.jsonsKema.FormatValidationFailure;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.LoadingContext;
import com.github.erosb.jsonsKema.Schema;
import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.net.InternetProtocolAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\"J\u0010\t\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"J\u0010\u0012\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\"J\u0010\u0014\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\"J\u0010\u0016\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\"J\u0010\u0018\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"J\u0010\u001d\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0016\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\"X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\"X\u0082T\u00a2\u0006\u0002\n\u0000\"J\u0010$\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\f\"J\u0010&\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\f\"J\u0010(\u001a8\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\f\"5\u0010*\u001a#\u0012\u0013\u0012\u00110,\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(-\u0012\u0006\u0012\u0004\u0018\u00010.0+j\u0002`/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101*n\u0010\u0000\"4\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000124\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0001\u00a8\u00062"}, d2={"FormatValidator", "Lkotlin/Function2;", "Lcom/github/erosb/jsonsKema/IJsonValue;", "Lkotlin/ParameterName;", "name", "instance", "Lcom/github/erosb/jsonsKema/FormatSchema;", "schema", "Lcom/github/erosb/jsonsKema/FormatValidationFailure;", "dateFormatValidator", "Lcom/github/erosb/jsonsKema/FormatValidator;", "getDateFormatValidator", "()Lkotlin/jvm/functions/Function2;", "DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "validateDateTime", "str", "Lcom/github/erosb/jsonsKema/IJsonString;", "dateTimeFormatValidator", "getDateTimeFormatValidator", "uriFormatValidator", "getUriFormatValidator", "emailFormatValidator", "getEmailFormatValidator", "ipv4FormatValidator", "getIpv4FormatValidator", "allowedIpv6Chars", "", "", "ipv6FormatValidator", "getIpv6FormatValidator", "TIME_FORMATTER", "kotlin.jvm.PlatformType", "MAX_OFFSET_MIN", "", "MIN_OFFSET_MIN", "timeFormatValidator", "getTimeFormatValidator", "uuidFormatValidator", "getUuidFormatValidator", "durationFormatValidator", "getDurationFormatValidator", "formatLoader", "Lkotlin/Function1;", "Lcom/github/erosb/jsonsKema/LoadingContext;", "context", "Lcom/github/erosb/jsonsKema/Schema;", "Lcom/github/erosb/jsonsKema/KeywordLoader;", "getFormatLoader", "()Lkotlin/jvm/functions/Function1;", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Format.kt\ncom/github/erosb/jsonsKema/FormatKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,188:1\n12546#2,2:189\n*S KotlinDebug\n*F\n+ 1 Format.kt\ncom/github/erosb/jsonsKema/FormatKt\n*L\n97#1:189,2\n*E\n"})
public final class FormatKt {
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> dateFormatValidator = FormatKt::dateFormatValidator$lambda$1;
    @NotNull
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> dateTimeFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> uriFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> emailFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> ipv4FormatValidator;
    @NotNull
    private static final Set<Character> allowedIpv6Chars;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> ipv6FormatValidator;
    private static final DateTimeFormatter TIME_FORMATTER;
    private static final int MAX_OFFSET_MIN = 1439;
    private static final int MIN_OFFSET_MIN = -1439;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> timeFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> uuidFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> durationFormatValidator;
    @NotNull
    private static final Function1<LoadingContext, Schema> formatLoader;

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getDateFormatValidator() {
        return dateFormatValidator;
    }

    private static final FormatValidationFailure validateDateTime(IJsonString str, FormatSchema schema) {
        try {
            String string = str.getValue().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            DATE_TIME_FORMATTER.parse(string);
            ZonedDateTime.parse(str.getValue());
        }
        catch (DateTimeParseException e) {
            String string = e.getMessage();
            if ((string != null ? StringsKt.indexOf$default((CharSequence)string, "Invalid value for SecondOfMinute", 0, false, 6, null) : -1) > -1 && StringsKt.indexOf$default((CharSequence)str.getValue(), "23:59:60", 0, false, 6, null) > -1) {
                JsonString sanitized = new JsonString(StringsKt.replace$default(str.getValue(), "23:59:60", "23:59:59", false, 4, null), str.getLocation());
                return FormatKt.validateDateTime(sanitized, schema);
            }
            return new FormatValidationFailure(schema, str);
        }
        return null;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getDateTimeFormatValidator() {
        return dateTimeFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getUriFormatValidator() {
        return uriFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getEmailFormatValidator() {
        return emailFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getIpv4FormatValidator() {
        return ipv4FormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getIpv6FormatValidator() {
        return ipv6FormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getTimeFormatValidator() {
        return timeFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getUuidFormatValidator() {
        return uuidFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, FormatValidationFailure> getDurationFormatValidator() {
        return durationFormatValidator;
    }

    @NotNull
    public static final Function1<LoadingContext, Schema> getFormatLoader() {
        return formatLoader;
    }

    private static final FormatValidationFailure dateFormatValidator$lambda$1$lambda$0(FormatSchema $schema, IJsonString str) {
        FormatValidationFailure formatValidationFailure;
        Intrinsics.checkNotNullParameter(str, "str");
        try {
            DateTimeFormatter.ISO_LOCAL_DATE.parse(str.getValue());
            formatValidationFailure = null;
        }
        catch (DateTimeParseException e) {
            formatValidationFailure = new FormatValidationFailure($schema, str);
        }
        return formatValidationFailure;
    }

    private static final FormatValidationFailure dateFormatValidator$lambda$1(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.dateFormatValidator$lambda$1$lambda$0(schema, arg_0));
    }

    private static final FormatValidationFailure dateTimeFormatValidator$lambda$4$lambda$3(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return FormatKt.validateDateTime(str, $schema);
    }

    private static final FormatValidationFailure dateTimeFormatValidator$lambda$4(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.dateTimeFormatValidator$lambda$4$lambda$3(schema, arg_0));
    }

    private static final FormatValidationFailure uriFormatValidator$lambda$6$lambda$5(FormatSchema $schema, IJsonString str) {
        FormatValidationFailure formatValidationFailure;
        Intrinsics.checkNotNullParameter(str, "str");
        try {
            formatValidationFailure = new URI(str.getValue()).getScheme() == null ? new FormatValidationFailure($schema, str) : null;
        }
        catch (URISyntaxException e) {
            formatValidationFailure = new FormatValidationFailure($schema, str);
        }
        return formatValidationFailure;
    }

    private static final FormatValidationFailure uriFormatValidator$lambda$6(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.uriFormatValidator$lambda$6$lambda$5(schema, arg_0));
    }

    private static final FormatValidationFailure emailFormatValidator$lambda$8$lambda$7(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return JMail.isValid(str.getValue()) ? null : new FormatValidationFailure($schema, str);
    }

    private static final FormatValidationFailure emailFormatValidator$lambda$8(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.emailFormatValidator$lambda$8$lambda$7(schema, arg_0));
    }

    private static final FormatValidationFailure ipv4FormatValidator$lambda$10$lambda$9(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return InternetProtocolAddress.validateIpv4(str.getValue()).isPresent() ? null : new FormatValidationFailure($schema, str);
    }

    private static final FormatValidationFailure ipv4FormatValidator$lambda$10(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.ipv4FormatValidator$lambda$10$lambda$9(schema, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final FormatValidationFailure ipv6FormatValidator$lambda$13$lambda$12(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        if (InternetProtocolAddress.validateIpv6(str.getValue()).isPresent()) {
            block4: {
                char[] cArray = str.getValue().toCharArray();
                Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
                char[] $this$all$iv = cArray;
                boolean $i$f$all = false;
                int n = 0;
                int n2 = $this$all$iv.length;
                while (n < n2) {
                    char element$iv;
                    char it = element$iv = $this$all$iv[n];
                    boolean bl = false;
                    if (allowedIpv6Chars.contains(Character.valueOf(it))) {
                        ++n;
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            boolean bl = false;
            if (bl) {
                return null;
            }
        }
        FormatValidationFailure formatValidationFailure = new FormatValidationFailure($schema, str);
        return formatValidationFailure;
    }

    private static final FormatValidationFailure ipv6FormatValidator$lambda$13(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.ipv6FormatValidator$lambda$13$lambda$12(schema, arg_0));
    }

    private static final FormatValidationFailure timeFormatValidator$lambda$15$lambda$14(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        try {
            int pos = StringsKt.indexOf$default((CharSequence)str.getValue(), 'Z', 0, false, 6, null);
            if (-1 != pos && pos != str.getValue().length() - 1) {
                return new FormatValidationFailure($schema, str);
            }
            TemporalAccessor temporalAccessor = TIME_FORMATTER.parseUnresolved(str.getValue(), new ParsePosition(0));
            if (temporalAccessor == null) {
                return new FormatValidationFailure($schema, str);
            }
            TemporalAccessor accessor = temporalAccessor;
            long offsetMins = accessor.getLong(ChronoField.OFFSET_SECONDS) / (long)60;
            if (1439L < offsetMins || -1439L > offsetMins) {
                return new FormatValidationFailure($schema, str);
            }
            long hr = accessor.getLong(ChronoField.HOUR_OF_DAY) - offsetMins / (long)60;
            long min = accessor.getLong(ChronoField.MINUTE_OF_HOUR) - offsetMins % (long)60;
            long sec = accessor.getLong(ChronoField.SECOND_OF_MINUTE);
            if (min < 0L) {
                hr += -1L;
                min += (long)60;
            }
            if (hr < 0L) {
                hr += (long)24;
            }
            boolean isStandardTimeRange = sec <= 59L && min <= 59L && hr <= 23L;
            boolean isSpecialCaseEndOfDay = sec == 60L && min == 59L && hr == 23L;
            return isStandardTimeRange || isSpecialCaseEndOfDay ? null : new FormatValidationFailure($schema, str);
        }
        catch (DateTimeException e) {
            return new FormatValidationFailure($schema, str);
        }
    }

    private static final FormatValidationFailure timeFormatValidator$lambda$15(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.timeFormatValidator$lambda$15$lambda$14(schema, arg_0));
    }

    private static final FormatValidationFailure uuidFormatValidator$lambda$17$lambda$16(FormatSchema $schema, IJsonString str) {
        FormatValidationFailure formatValidationFailure;
        Intrinsics.checkNotNullParameter(str, "str");
        if (str.getValue().length() == 36) {
            FormatValidationFailure formatValidationFailure2;
            try {
                UUID.fromString(str.getValue());
                formatValidationFailure2 = null;
            }
            catch (IllegalArgumentException e) {
                formatValidationFailure2 = new FormatValidationFailure($schema, str);
            }
            formatValidationFailure = formatValidationFailure2;
        } else {
            formatValidationFailure = new FormatValidationFailure($schema, str);
        }
        return formatValidationFailure;
    }

    private static final FormatValidationFailure uuidFormatValidator$lambda$17(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.uuidFormatValidator$lambda$17$lambda$16(schema, arg_0));
    }

    private static final FormatValidationFailure durationFormatValidator$lambda$19$lambda$18(FormatSchema $schema, IJsonString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        Pattern regex = Pattern.compile("^P(?=\\d|T\\d)(?:(\\d+)Y)?(?:(\\d+)M)?(?:(\\d+)([DW]))?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+(?:\\.\\d+)?)S)?)?$");
        if (!regex.matcher(str.getValue()).matches()) {
            return new FormatValidationFailure($schema, str);
        }
        return null;
    }

    private static final FormatValidationFailure durationFormatValidator$lambda$19(IJsonValue inst, FormatSchema schema) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        Intrinsics.checkNotNullParameter(schema, "schema");
        return inst.maybeString(arg_0 -> FormatKt.durationFormatValidator$lambda$19$lambda$18(schema, arg_0));
    }

    private static final FormatSchema formatLoader$lambda$20(LoadingContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return new FormatSchema(ctx.getKeywordValue().requireString().getValue(), ctx.getLocation());
    }

    static {
        boolean bl = false;
        DateTimeFormatter secondsFractionFormatter = new DateTimeFormatterBuilder().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter();
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendOptional(secondsFractionFormatter).appendPattern("XXX").toFormatter().withResolverStyle(ResolverStyle.STRICT);
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "run(...)");
        DATE_TIME_FORMATTER = dateTimeFormatter;
        dateTimeFormatValidator = FormatKt::dateTimeFormatValidator$lambda$4;
        uriFormatValidator = FormatKt::uriFormatValidator$lambda$6;
        emailFormatValidator = FormatKt::emailFormatValidator$lambda$8;
        ipv4FormatValidator = FormatKt::ipv4FormatValidator$lambda$10;
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(':')};
        allowedIpv6Chars = SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.setOf(characterArray), new CharRange('0', '9')), new CharRange('a', 'f')), new CharRange('A', 'F'));
        ipv6FormatValidator = FormatKt::ipv6FormatValidator$lambda$13;
        TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:MM", "Z").parseLenient().toFormatter();
        timeFormatValidator = FormatKt::timeFormatValidator$lambda$15;
        uuidFormatValidator = FormatKt::uuidFormatValidator$lambda$17;
        durationFormatValidator = FormatKt::durationFormatValidator$lambda$19;
        formatLoader = FormatKt::formatLoader$lambda$20;
    }
}

