/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.dns;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

public final class DNSLookupUtil {
    private static final int DEFAULT_INITIAL_TIMEOUT = 100;
    private static final int DEFAULT_RETRIES = 2;
    private static final String NO_SERVICE_MX_PR_RDATA = "0 .";

    private DNSLookupUtil() {
    }

    public static boolean hasMXRecord(String domain) {
        return DNSLookupUtil.hasMXRecord(domain, 100, 2);
    }

    public static boolean hasMXRecord(String domain, int initialTimeout, int numRetries) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("com.sun.jndi.dns.timeout.initial", String.valueOf(initialTimeout));
        env.put("com.sun.jndi.dns.timeout.retries", String.valueOf(numRetries));
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attribute attr = ctx.getAttributes(domain, new String[]{"MX"}).get("MX");
            return attr != null && attr.size() > 0 && !attr.get(0).equals(NO_SERVICE_MX_PR_RDATA);
        }
        catch (NamingException e) {
            return false;
        }
    }
}

