/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.normalization;

import java.util.function.Function;

public enum CaseOption {
    NO_CHANGE(String::toString, String::toString),
    LOWERCASE(String::toLowerCase, String::toLowerCase),
    LOWERCASE_DOMAIN_ONLY(String::toString, String::toLowerCase),
    LOWERCASE_LOCAL_PART_ONLY(String::toLowerCase, String::toString),
    UPPERCASE(String::toUpperCase, String::toUpperCase),
    UPPERCASE_DOMAIN_ONLY(String::toString, String::toUpperCase),
    UPPERCASE_LOCAL_PART_ONLY(String::toUpperCase, String::toString);

    private final Function<String, String> localPartAdjuster;
    private final Function<String, String> domainAdjuster;

    private CaseOption(Function<String, String> localPartAdjuster, Function<String, String> domainAdjuster) {
        this.localPartAdjuster = localPartAdjuster;
        this.domainAdjuster = domainAdjuster;
    }

    public String adjustLocalPart(String localPart) {
        return this.localPartAdjuster.apply(localPart);
    }

    public String adjustDomain(String domain) {
        return this.domainAdjuster.apply(domain);
    }
}

