/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESSignatureExtension
implements Serializable {
    private static final long serialVersionUID = 4054926235641779454L;
    protected final CertificateVerifier certificateVerifier;
    protected final TSPSource tspSource;
    private CAdESService cadesService;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder;

    public ASiCWithCAdESSignatureExtension(CertificateVerifier certificateVerifier, TSPSource tspSource) {
        this.certificateVerifier = certificateVerifier;
        this.tspSource = tspSource;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    public ASiCContent extend(ASiCContent asicContent, CAdESSignatureParameters parameters) {
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        ASiCContainerType containerType = asicContent.getContainerType();
        if (containerType == null) {
            throw new IllegalInputException("The container type of the provided document is not supported or cannot be extracted!");
        }
        for (DSSDocument signature : signatureDocuments) {
            boolean coveredByArchiveManifest = this.isCoveredByArchiveManifest(asicContent, signature);
            if (!this.extensionRequired(parameters, coveredByArchiveManifest)) continue;
            boolean coveredByAnyManifest = this.isCoveredByAnyManifest(asicContent, signature);
            this.assertExtendSignaturePossible(parameters, coveredByAnyManifest);
            DSSDocument extendedSignature = this.extendSignatureDocument(signature, asicContent, parameters);
            ASiCUtils.addOrReplaceDocument(signatureDocuments, extendedSignature);
        }
        return asicContent;
    }

    private DSSDocument extendSignatureDocument(DSSDocument signature, ASiCContent asicContent, CAdESSignatureParameters cadesParameters) {
        List<DSSDocument> detachedContents = this.getDetachedContents(signature, asicContent);
        cadesParameters.getContext().setDetachedContents(detachedContents);
        String originalName = signature.getName();
        DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
        extendDocument.setName(originalName);
        return extendDocument;
    }

    private List<DSSDocument> getDetachedContents(DSSDocument signatureDocument, ASiCContent asicContent) {
        if (ASiCContainerType.ASiC_E == asicContent.getContainerType()) {
            List<DSSDocument> manifests = asicContent.getManifestDocuments();
            DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest(manifests, signatureDocument.getName());
            return Collections.singletonList(linkedManifest);
        }
        return asicContent.getSignedDocuments();
    }

    protected DigestAlgorithm getReferenceDigestAlgorithmOrDefault(CAdESSignatureParameters params) {
        return params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
    }

    private CAdESService getCAdESService() {
        if (this.cadesService == null) {
            this.cadesService = new CAdESService(this.certificateVerifier);
            this.cadesService.setTspSource(this.tspSource);
            if (CAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER != this.resourcesHandlerBuilder) {
                this.cadesService.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
            }
        }
        return this.cadesService;
    }

    protected boolean extensionRequired(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        return SignatureLevel.CAdES_BASELINE_T.equals((Object)signatureLevel) || SignatureLevel.CAdES_BASELINE_LT.equals((Object)signatureLevel) || !coveredByManifest;
    }

    protected void assertExtendSignaturePossible(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if ((SignatureLevel.CAdES_BASELINE_T.equals((Object)signatureLevel) || SignatureLevel.CAdES_BASELINE_LT.equals((Object)signatureLevel)) && coveredByManifest) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already covered by a manifest file.", new Object[]{signatureLevel}));
        }
    }

    protected boolean isCoveredByArchiveManifest(ASiCContent asicContent, DSSDocument signature) {
        return ASiCUtils.isCoveredByManifest(asicContent.getArchiveManifestDocuments(), signature.getName());
    }

    protected boolean isCoveredByAnyManifest(ASiCContent asicContent, DSSDocument signature) {
        return ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), signature.getName());
    }
}

