/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.merge;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.merge.ASiCContainerMerger;
import eu.europa.esig.dss.asic.common.merge.ASiCContainerMergerFactory;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public abstract class DefaultContainerMerger
implements ASiCContainerMerger {
    protected static final DigestAlgorithm DEFAULT_DIGEST_ALGORITHM = DigestAlgorithm.SHA256;
    protected ASiCContent[] asicContents;
    private Date creationTime;

    protected DefaultContainerMerger() {
    }

    protected DefaultContainerMerger(DSSDocument ... containers) {
        DefaultContainerMerger.assertNotNull(containers);
        this.asicContents = this.toASiCContentArray(containers);
    }

    protected DefaultContainerMerger(ASiCContent ... asicContents) {
        DefaultContainerMerger.assertNotNull(asicContents);
        this.asicContents = asicContents;
    }

    private ASiCContent[] toASiCContentArray(DSSDocument ... containers) {
        ASiCContent[] asicContentArray = new ASiCContent[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            asicContentArray[i] = this.getContainerExtractor(containers[i]).extract();
        }
        return asicContentArray;
    }

    protected abstract DefaultASiCContainerExtractor getContainerExtractor(DSSDocument var1);

    public Date getCreationTime() {
        if (this.creationTime == null) {
            this.creationTime = new Date();
        }
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public static ASiCContainerMerger fromDocuments(DSSDocument ... containers) {
        DefaultContainerMerger.assertNotNull(containers);
        ServiceLoader<ASiCContainerMergerFactory> serviceLoaders = ServiceLoader.load(ASiCContainerMergerFactory.class);
        for (ASiCContainerMergerFactory mergerFactory : serviceLoaders) {
            if (!mergerFactory.isSupported(containers)) continue;
            return mergerFactory.create(containers);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    public static ASiCContainerMerger fromASiCContents(ASiCContent ... asicContents) {
        DefaultContainerMerger.assertNotNull(asicContents);
        ServiceLoader<ASiCContainerMergerFactory> serviceLoaders = ServiceLoader.load(ASiCContainerMergerFactory.class);
        for (ASiCContainerMergerFactory mergerFactory : serviceLoaders) {
            if (!mergerFactory.isSupported(asicContents)) continue;
            return mergerFactory.create(asicContents);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    @Override
    public boolean isSupported(DSSDocument ... containers) {
        DefaultContainerMerger.assertNotNull(containers);
        for (DSSDocument containerDocument : containers) {
            if (!ASiCUtils.isZip(containerDocument)) {
                throw new IllegalInputException(String.format("The document with name '%s' is not a ZIP archive!", containerDocument.getName()));
            }
            if (this.isSupported(containerDocument)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isSupported(DSSDocument var1);

    @Override
    public boolean isSupported(ASiCContent ... asicContents) {
        DefaultContainerMerger.assertNotNull(asicContents);
        for (ASiCContent asicContent : asicContents) {
            if (this.isSupported(asicContent)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isSupported(ASiCContent var1);

    @Override
    public DSSDocument merge() {
        ASiCContent mergeResult = this.mergeToASiCContent();
        DSSDocument containerDocument = ZipUtils.getInstance().createZipArchive(mergeResult, this.getCreationTime());
        containerDocument.setName(this.getFinalContainerName(mergeResult.getContainerType()));
        containerDocument.setMimeType(ASiCContainerType.ASiC_S.equals((Object)mergeResult.getContainerType()) ? MimeTypeEnum.ASICS : MimeTypeEnum.ASICE);
        return containerDocument;
    }

    @Override
    public ASiCContent mergeToASiCContent() {
        if (this.asicContents == null || this.asicContents.length == 0) {
            throw new NullPointerException("At least one container shall be provided!");
        }
        this.ensureContainerContentAllowMerge();
        this.ensureSignaturesAllowMerge();
        return this.createMergedResult();
    }

    protected abstract void ensureContainerContentAllowMerge();

    protected abstract void ensureSignaturesAllowMerge();

    protected ASiCContent createMergedResult() {
        ASiCContent asicContent = this.createEmptyContainer();
        asicContent.setZipComment(this.getZipComment());
        asicContent.setMimeTypeDocument(this.getMimeTypeDocument());
        asicContent.setSignedDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getSignedDocuments).collect(Collectors.toList())));
        asicContent.setSignatureDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getSignatureDocuments).collect(Collectors.toList())));
        asicContent.setManifestDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getManifestDocuments).collect(Collectors.toList())));
        asicContent.setArchiveManifestDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getArchiveManifestDocuments).collect(Collectors.toList())));
        asicContent.setEvidenceRecordManifestDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getEvidenceRecordManifestDocuments).collect(Collectors.toList())));
        asicContent.setTimestampDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getTimestampDocuments).collect(Collectors.toList())));
        asicContent.setEvidenceRecordDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getEvidenceRecordDocuments).collect(Collectors.toList())));
        asicContent.setUnsupportedDocuments(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getUnsupportedDocuments).collect(Collectors.toList())));
        asicContent.setFolders(this.mergeDocumentLists(Arrays.stream(this.asicContents).map(ASiCContent::getFolders).collect(Collectors.toList())));
        return asicContent;
    }

    protected ASiCContent createEmptyContainer() {
        ASiCContent asicContent = new ASiCContent();
        asicContent.setContainerType(this.getContainerType());
        return asicContent;
    }

    private ASiCContainerType getContainerType() {
        for (ASiCContent asicContent : this.asicContents) {
            if (asicContent.getContainerType() == null) continue;
            return asicContent.getContainerType();
        }
        return this.getTargetASiCContainerType();
    }

    protected abstract ASiCContainerType getTargetASiCContainerType();

    private String getZipComment() {
        String zipComment = null;
        for (ASiCContent asicContent : this.asicContents) {
            String currentZipComment = asicContent.getZipComment();
            if (!Utils.isStringNotEmpty(currentZipComment)) continue;
            if (Utils.isStringEmpty(zipComment)) {
                zipComment = currentZipComment;
                continue;
            }
            if (zipComment == null || zipComment.equals(currentZipComment)) continue;
            throw new UnsupportedOperationException(String.format("Unable to merge containers. Containers contain different zip comments : '%s' and '%s'!", zipComment, currentZipComment));
        }
        return zipComment;
    }

    private DSSDocument getMimeTypeDocument() {
        DSSDocument mimeType = null;
        for (ASiCContent asicContent : this.asicContents) {
            DSSDocument currentMimeTypeDocument = asicContent.getMimeTypeDocument();
            if (currentMimeTypeDocument == null) continue;
            if (mimeType == null) {
                mimeType = currentMimeTypeDocument;
                continue;
            }
            if (Arrays.equals(mimeType.getDigestValue(DEFAULT_DIGEST_ALGORITHM), currentMimeTypeDocument.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
            throw new UnsupportedOperationException(String.format("Unable to merge containers. Containers contain different mimetype documents!", new Object[0]));
        }
        return mimeType;
    }

    private List<DSSDocument> mergeDocumentLists(Collection<List<DSSDocument>> documentsLists) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        ArrayList<String> addedDocumentNames = new ArrayList<String>();
        for (List<DSSDocument> documentsList : documentsLists) {
            for (DSSDocument document : documentsList) {
                if (!addedDocumentNames.contains(document.getName())) {
                    result.add(document);
                    addedDocumentNames.add(document.getName());
                    continue;
                }
                DSSDocument originalListDocument = DSSUtils.getDocumentWithName(result, document.getName());
                if (Arrays.equals(originalListDocument.getDigestValue(DEFAULT_DIGEST_ALGORITHM), document.getDigestValue(DEFAULT_DIGEST_ALGORITHM))) continue;
                throw new UnsupportedOperationException(String.format("Unable to merge containers. Containers contain different documents under the same name : %s!", document.getName()));
            }
        }
        return result;
    }

    protected String getFinalContainerName(ASiCContainerType asicContainerType) {
        String originalFilename = this.getOriginalContainerFilename();
        String originalExtension = Utils.getFileNameExtension(originalFilename);
        if (Utils.isStringNotEmpty(originalExtension)) {
            originalFilename = originalFilename.substring(0, originalFilename.length() - originalExtension.length() - 1);
        }
        StringBuilder sb = new StringBuilder(originalFilename);
        sb.append("-merged");
        sb.append(".");
        String finalExtension = this.getFinalExtension(asicContainerType, originalExtension);
        sb.append(finalExtension);
        return sb.toString();
    }

    private String getOriginalContainerFilename() {
        for (ASiCContent asicContent : this.asicContents) {
            if (asicContent.getAsicContainer() == null || asicContent.getAsicContainer().getName() == null) continue;
            return asicContent.getAsicContainer().getName();
        }
        return "container";
    }

    private String getFinalExtension(ASiCContainerType asicContainerType, String originalExtension) {
        if (Utils.isStringNotEmpty(originalExtension)) {
            return originalExtension;
        }
        if (asicContainerType != null) {
            MimeTypeEnum mimeType = ASiCContainerType.ASiC_S.equals((Object)asicContainerType) ? MimeTypeEnum.ASICS : MimeTypeEnum.ASICE;
            return mimeType.getExtension();
        }
        return "zip";
    }

    private static void assertNotNull(DSSDocument ... containers) {
        Objects.requireNonNull(containers, "Documents shall be provided!");
        if (containers.length == 0) {
            throw new NullPointerException("At least one document shall be provided!");
        }
        for (DSSDocument containerDocument : containers) {
            Objects.requireNonNull(containerDocument, "DSSDocument cannot be null!");
        }
    }

    private static void assertNotNull(ASiCContent ... asicContents) {
        Objects.requireNonNull(asicContents, "ASiCContents shall be provided!");
        if (asicContents.length == 0) {
            throw new NullPointerException("At least one ASiCContent shall be provided!");
        }
        for (ASiCContent asicContent : asicContents) {
            Objects.requireNonNull(asicContent, "ASiCContent cannot be null!");
        }
    }
}

