/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlArchiveTimestampHashIndex;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.x509.tsp.ArchiveTimestampHashIndexStatus;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;

public class CAdESDiagnosticDataBuilder
extends SignedDocumentDiagnosticDataBuilder {
    @Override
    public XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = super.buildDetachedXmlSignature(signature);
        CAdESSignature cadesSignature = (CAdESSignature)signature;
        xmlSignature.setContentIdentifier(cadesSignature.getContentIdentifier());
        xmlSignature.setContentHints(cadesSignature.getContentHints());
        xmlSignature.setSignerInformationStore(this.getXmlSignerInformationStore(cadesSignature.getSignerInformationStoreInfos()));
        return xmlSignature;
    }

    @Override
    protected XmlTimestamp buildDetachedXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestamp = super.buildDetachedXmlTimestamp(timestampToken);
        ArchiveTimestampHashIndexStatus atsHashIndexStatus = timestampToken.getAtsHashIndexStatus();
        if (atsHashIndexStatus != null) {
            XmlArchiveTimestampHashIndex xmlAtsHashIndex = new XmlArchiveTimestampHashIndex();
            xmlAtsHashIndex.setVersion(atsHashIndexStatus.getVersion());
            xmlAtsHashIndex.setValid(Utils.isCollectionEmpty(atsHashIndexStatus.getErrorMessages()));
            xmlAtsHashIndex.getMessages().addAll(atsHashIndexStatus.getErrorMessages());
            xmlTimestamp.setArchiveTimestampHashIndex(xmlAtsHashIndex);
        }
        return xmlTimestamp;
    }
}

