/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecomputedDigestCalculatorProvider
implements DigestCalculatorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PrecomputedDigestCalculatorProvider.class);
    private final DSSDocument digestDocument;

    public PrecomputedDigestCalculatorProvider(DSSDocument dssDocument) {
        this.digestDocument = dssDocument;
    }

    @Override
    public DigestCalculator get(final AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        final byte[] digestBase64 = this.getDigestBase64(digestAlgorithmIdentifier);
        return new DigestCalculator(){

            @Override
            public OutputStream getOutputStream() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    Utils.write(this.getDigest(), os);
                }
                catch (IOException e) {
                    throw new DSSException("Unable to get outputstream", e);
                }
                return os;
            }

            @Override
            public byte[] getDigest() {
                return digestBase64;
            }

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return digestAlgorithmIdentifier;
            }
        };
    }

    private byte[] getDigestBase64(AlgorithmIdentifier digestAlgorithmIdentifier) {
        try {
            ASN1ObjectIdentifier algorithmOid = digestAlgorithmIdentifier.getAlgorithm();
            return this.digestDocument.getDigestValue(DigestAlgorithm.forOID(algorithmOid.getId()));
        }
        catch (Exception e) {
            LOG.warn("Unable to retrieve digest value for an algorithm '{}'. Reason : {}", (Object)digestAlgorithmIdentifier.getAlgorithm().getId(), (Object)e.getMessage());
            return DSSUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

