/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import eu.europa.esig.dss.crl.AbstractCRLUtils;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.crl.stream.impl.CRLInfo;
import eu.europa.esig.dss.crl.stream.impl.CRLParser;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.X509CRLEntry;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtilsStreamImpl
extends AbstractCRLUtils
implements ICRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtilsStreamImpl.class);

    @Override
    public CRLValidity buildCRLValidity(CRLBinary crlBinary, CertificateToken issuerToken) throws IOException {
        CRLValidity crlValidity = new CRLValidity(crlBinary);
        CRLInfo crlInfos = this.getCrlInfo(crlValidity);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOidAndParams(crlInfos.getCertificateListSignatureAlgorithmOid(), crlInfos.getCertificateListSignatureAlgorithmParams());
        crlValidity.setSignatureAlgorithm(signatureAlgorithm);
        crlValidity.setThisUpdate(crlInfos.getThisUpdate());
        crlValidity.setNextUpdate(crlInfos.getNextUpdate());
        crlValidity.setCriticalExtensionsOid(crlInfos.getCriticalExtensions().keySet());
        this.extractIssuingDistributionPointBinary(crlValidity, crlInfos.getCriticalExtension(Extension.issuingDistributionPoint.getId()));
        this.extractExpiredCertsOnCRL(crlValidity, crlInfos.getNonCriticalExtension(Extension.expiredCertsOnCRL.getId()));
        X500Principal x509CRLIssuerX500Principal = crlInfos.getIssuer();
        X500Principal issuerTokenSubjectX500Principal = issuerToken.getSubject().getPrincipal();
        if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
            crlValidity.setIssuerX509PrincipalMatches(true);
        }
        this.checkSignatureValue(crlValidity, crlInfos.getSignatureValue(), signatureAlgorithm, crlInfos.getCertificateListSignatureAlgorithmParams(), this.getSignedData(crlValidity), issuerToken);
        return crlValidity;
    }

    /*
     * Exception decompiling
     */
    private byte[] getSignedData(CRLValidity crlValidity) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        CRLParser parser = new CRLParser();
        X509CRLEntry crlEntry = null;
        try (InputStream is = crlValidity.toCRLInputStream();){
            crlEntry = parser.retrieveRevocationInfo(is, serialNumber);
        }
        catch (IOException e) {
            LOG.warn("Unable to retrieve the revocation status", e);
        }
        return crlEntry;
    }

    private void checkSignatureValue(CRLValidity crlValidity, byte[] signatureValue, SignatureAlgorithm signatureAlgorithm, byte[] params, byte[] signedData, CertificateToken signer) {
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm.getJCEId());
            AlgorithmParameterSpec algoParamSpec = this.createAlgoParamSpec(signatureAlgorithm, params);
            if (algoParamSpec != null) {
                signature.setParameter(algoParamSpec);
            }
            signature.initVerify(signer.getPublicKey());
            signature.update(signedData);
            if (signature.verify(signatureValue)) {
                crlValidity.setSignatureIntact(true);
                crlValidity.setIssuerToken(signer);
                boolean crlSign = signer.checkKeyUsage(KeyUsageBit.CRL_SIGN);
                if (!crlSign) {
                    crlValidity.setSignatureInvalidityReason(String.format("CRL issuer does not have '%s' key usage!", KeyUsageBit.CRL_SIGN.getValue()));
                }
                crlValidity.setCrlSignKeyUsage(crlSign);
            } else {
                crlValidity.setSignatureInvalidityReason("CRL Signature is not intact.");
            }
        }
        catch (Exception e) {
            String msg = String.format("CRL Signature cannot be validated : %s", e.getMessage());
            if (LOG.isTraceEnabled()) {
                LOG.trace(msg, e);
            }
            crlValidity.setSignatureInvalidityReason(msg);
        }
    }

    private CRLInfo getCrlInfo(CRLValidity crlValidity) throws IOException {
        try (InputStream is = crlValidity.toCRLInputStream();){
            CRLInfo cRLInfo;
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                CRLParser parser = new CRLParser();
                cRLInfo = parser.retrieveInfo(bis);
            }
            return cRLInfo;
        }
    }

    private AlgorithmParameterSpec createAlgoParamSpec(SignatureAlgorithm signatureAlgorithm, byte[] params) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException {
        if (params == null) {
            return null;
        }
        AlgorithmParameters sigParams = AlgorithmParameters.getInstance(signatureAlgorithm.getJCEId());
        sigParams.init(params);
        if (EncryptionAlgorithm.RSASSA_PSS == signatureAlgorithm.getEncryptionAlgorithm()) {
            return sigParams.getParameterSpec(PSSParameterSpec.class);
        }
        LOG.warn("Only RSASSA_PSS signature parameters are supported!");
        return null;
    }
}

