/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.digest.AbstractEvidenceRecordRenewalDigestBuilderHelper;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1ArchiveTimeStampSequenceDigestHelper
extends AbstractEvidenceRecordRenewalDigestBuilderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ASN1ArchiveTimeStampSequenceDigestHelper.class);

    public ASN1ArchiveTimeStampSequenceDigestHelper(ASN1EvidenceRecord evidenceRecord) {
        super(evidenceRecord);
    }

    @Override
    public DSSMessageDigest buildTimeStampRenewalDigest(ArchiveTimeStampObject archiveTimeStamp) {
        ArchiveTimeStampChainObject archiveTimeStampChain = this.getArchiveTimeStampChainObject(archiveTimeStamp);
        return this.buildTimeStampRenewalDigest(archiveTimeStamp, archiveTimeStampChain.getDigestAlgorithm());
    }

    public DSSMessageDigest buildTimeStampRenewalDigest(ArchiveTimeStampObject archiveTimeStamp, DigestAlgorithm digestAlgorithm) {
        ASN1ArchiveTimeStampObject asn1ArchiveTimeStampObject = (ASN1ArchiveTimeStampObject)archiveTimeStamp;
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, asn1ArchiveTimeStampObject.getTimestampToken().getEncoded());
        return new DSSMessageDigest(digestAlgorithm, digestValue);
    }

    @Override
    public DSSMessageDigest buildArchiveTimeStampSequenceDigest(ArchiveTimeStampChainObject archiveTimeStampChain) {
        ArchiveTimeStampChainObject nextArchiveTimeStampChain = this.getNextArchiveTimeStampChain(archiveTimeStampChain);
        return this.buildArchiveTimeStampSequenceDigest(nextArchiveTimeStampChain.getDigestAlgorithm(), nextArchiveTimeStampChain.getOrder());
    }

    public DSSMessageDigest buildArchiveTimeStampSequenceDigest(DigestAlgorithm digestAlgorithm, int archiveTimeStampChainOrder) {
        ArchiveTimeStampSequence archiveTimeStampSequence = this.getArchiveTimeStampSequence();
        ArchiveTimeStampChain[] childNodes = archiveTimeStampSequence.getArchiveTimeStampChains();
        ArchiveTimeStampChain[] archiveTimeStampChain = new ArchiveTimeStampChain[--archiveTimeStampChainOrder];
        for (int i = 0; i < childNodes.length; ++i) {
            if (i >= archiveTimeStampChainOrder) continue;
            archiveTimeStampChain[i] = childNodes[i];
        }
        ArchiveTimeStampSequence recreatedArchiveTimeStampSequence = new ArchiveTimeStampSequence(archiveTimeStampChain);
        try {
            return new DSSMessageDigest(digestAlgorithm, DSSUtils.digest(digestAlgorithm, recreatedArchiveTimeStampSequence.toASN1Primitive().getEncoded()));
        }
        catch (IOException e) {
            LOG.warn("Unable to generate ASN1 TimeStampSequence. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private ArchiveTimeStampSequence getArchiveTimeStampSequence() {
        ASN1EvidenceRecord asn1EvidenceRecord = (ASN1EvidenceRecord)this.evidenceRecord;
        return asn1EvidenceRecord.getEvidenceRecord().getArchiveTimeStampSequence();
    }

    public DSSMessageDigest computeChainAndDocumentHash(Digest archiveTimeStampChainHash, DSSDocument document) {
        DigestAlgorithm digestAlgorithm = archiveTimeStampChainHash.getAlgorithm();
        return this.computeChainAndDocumentHash(archiveTimeStampChainHash, document.getDigest(digestAlgorithm));
    }

    public DSSMessageDigest computeChainAndDocumentHash(Digest archiveTimeStampChainHash, Digest documentDigest) {
        DigestAlgorithm digestAlgorithm = archiveTimeStampChainHash.getAlgorithm();
        byte[] documentMessageDigest = documentDigest.getValue();
        ArrayList<byte[]> hashValueList = new ArrayList<byte[]>();
        hashValueList.add(documentMessageDigest);
        hashValueList.add(archiveTimeStampChainHash.getValue());
        if (Utils.collectionSize(hashValueList) == 1) {
            return new DSSMessageDigest(digestAlgorithm, (byte[])hashValueList.get(0));
        }
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(digestAlgorithm);
        for (byte[] hashValue : hashValueList) {
            digestCalculator.update(hashValue);
        }
        return digestCalculator.getMessageDigest(digestAlgorithm);
    }
}

