/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.evidencerecord.asn1.digest.ASN1ArchiveTimeStampSequenceDigestHelper;
import eu.europa.esig.dss.evidencerecord.asn1.digest.ASN1EvidenceRecordDataObjectDigestBuilder;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1EvidenceRecordTimeStampSequenceVerifier
extends EvidenceRecordTimeStampSequenceVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(ASN1EvidenceRecordTimeStampSequenceVerifier.class);

    public ASN1EvidenceRecordTimeStampSequenceVerifier(ASN1EvidenceRecord evidenceRecord) {
        super(evidenceRecord);
    }

    @Override
    protected DataObjectDigestBuilder getDataObjectDigestBuilder(DSSDocument document, ArchiveTimeStampChainObject archiveTimeStampChain) {
        DigestAlgorithm digestAlgorithm = archiveTimeStampChain.getDigestAlgorithm();
        return new ASN1EvidenceRecordDataObjectDigestBuilder(document, digestAlgorithm);
    }

    @Override
    protected DSSDocument getMatchingDocument(Digest digest, ArchiveTimeStampChainObject archiveTimeStampChain, DSSMessageDigest lastTimeStampSequenceHash, List<DSSDocument> detachedContents) {
        if (lastTimeStampSequenceHash.isEmpty()) {
            return super.getMatchingDocument(digest, archiveTimeStampChain, lastTimeStampSequenceHash, detachedContents);
        }
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument document : detachedContents) {
                DSSMessageDigest chainAndDocumentHash = this.getEvidenceRecordRenewalDigestBuilderHelper().computeChainAndDocumentHash((Digest)lastTimeStampSequenceHash, document);
                byte[] documentDigest = chainAndDocumentHash.getValue();
                if (!Arrays.equals(digest.getValue(), documentDigest)) continue;
                return document;
            }
        }
        return null;
    }

    @Override
    protected boolean checkHashTreeValidity(ArchiveTimeStampObject archiveTimeStamp, ArchiveTimeStampChainObject archiveTimeStampChain) {
        ASN1ArchiveTimeStampObject asn1ArchiveTimeStampObject = (ASN1ArchiveTimeStampObject)archiveTimeStamp;
        if (asn1ArchiveTimeStampObject.getDigestAlgorithm() != archiveTimeStampChain.getDigestAlgorithm()) {
            LOG.warn("The DigestAlgorithm '{}' found in ArchiveTimeStamp does not correspond to the DigestAlgorithm within the old Archive Timestamp '{}'! Unable to ensure validity of referenced content.", (Object)asn1ArchiveTimeStampObject.getDigestAlgorithm().getName(), (Object)archiveTimeStampChain.getDigestAlgorithm().getName());
            return false;
        }
        return true;
    }

    @Override
    protected DSSMessageDigest computeTimeStampHash(ArchiveTimeStampObject archiveTimeStamp) {
        return this.getEvidenceRecordRenewalDigestBuilderHelper().buildTimeStampRenewalDigest(archiveTimeStamp);
    }

    @Override
    protected DSSMessageDigest computeTimeStampSequenceHash(ArchiveTimeStampChainObject archiveTimeStampChain) {
        return this.getEvidenceRecordRenewalDigestBuilderHelper().buildArchiveTimeStampSequenceDigest(archiveTimeStampChain);
    }

    @Override
    protected List<ReferenceValidation> validateArchiveTimeStampSequenceDigest(List<ReferenceValidation> referenceValidations, DSSMessageDigest lastTimeStampSequenceHashes) {
        return referenceValidations;
    }

    @Override
    protected List<ReferenceValidation> validateMasterSignatureDigest(List<ReferenceValidation> referenceValidations, DigestAlgorithm digestAlgorithm, DSSMessageDigest lastTimeStampSequenceHash) {
        EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = this.evidenceRecord.getEmbeddedEvidenceRecordHelper();
        Digest masterSignatureDigest = embeddedEvidenceRecordHelper.getMasterSignatureDigest(digestAlgorithm);
        if (!this.isMasterSignatureDigestFound(referenceValidations = this.validateDigestForLastTimeStampSequence(referenceValidations, masterSignatureDigest, lastTimeStampSequenceHash, DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE)) && embeddedEvidenceRecordHelper.isEncodingSelectionSupported()) {
            LOG.debug("Unable to match digest of a master signature for the evidence record by computing the hash using existing coding, try to compute the hash using DER coding...");
            masterSignatureDigest = embeddedEvidenceRecordHelper.getMasterSignatureDigest(digestAlgorithm, true);
            referenceValidations = this.validateDigestForLastTimeStampSequence(referenceValidations, masterSignatureDigest, lastTimeStampSequenceHash, DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE);
        }
        if (EvidenceRecordIncorporationType.EXTERNAL_EVIDENCE_RECORD == this.evidenceRecord.getIncorporationType()) {
            Digest detachedDocumentDigest = this.getDetachedDocumentDigestForExternalEvidenceRecord(digestAlgorithm);
            referenceValidations = this.validateDigestForLastTimeStampSequence(referenceValidations, detachedDocumentDigest, lastTimeStampSequenceHash, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT);
        }
        return referenceValidations;
    }

    private List<ReferenceValidation> validateDigestForLastTimeStampSequence(List<ReferenceValidation> referenceValidations, Digest digestToValidate, DSSMessageDigest lastTimeStampSequenceHash, DigestMatcherType digestMatcherType) {
        if (!lastTimeStampSequenceHash.isEmpty()) {
            digestToValidate = this.getEvidenceRecordRenewalDigestBuilderHelper().computeChainAndDocumentHash((Digest)lastTimeStampSequenceHash, digestToValidate);
        }
        return this.validateAdditionalDigest(referenceValidations, digestToValidate, digestMatcherType);
    }

    private boolean isMasterSignatureDigestFound(List<ReferenceValidation> referenceValidations) {
        return referenceValidations.stream().anyMatch(r -> DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE == r.getType() && r.isIntact());
    }

    private Digest getDetachedDocumentDigestForExternalEvidenceRecord(DigestAlgorithm digestAlgorithm) {
        if (this.detachedContentPresentForExternalEvidenceRecord()) {
            return this.evidenceRecord.getDetachedContents().get(0).getDigest(digestAlgorithm);
        }
        LOG.warn("One and only one detached document was expected on validation of an 'external-evidence-records'. Provided documents: '{}'", (Object)Utils.collectionSize(this.evidenceRecord.getDetachedContents()));
        return new Digest();
    }

    private boolean detachedContentPresentForExternalEvidenceRecord() {
        return Utils.collectionSize(this.evidenceRecord.getDetachedContents()) == 1;
    }

    @Override
    protected List<byte[]> getLastTimeStampSequenceHashList(DSSMessageDigest lastTimeStampSequenceHash, List<DSSDocument> detachedDocuments) {
        if (Utils.isCollectionEmpty(detachedDocuments)) {
            return super.getLastTimeStampSequenceHashList(lastTimeStampSequenceHash, detachedDocuments);
        }
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        for (DSSDocument document : detachedDocuments) {
            DSSMessageDigest documentMessageDigest = this.getEvidenceRecordRenewalDigestBuilderHelper().computeChainAndDocumentHash((Digest)lastTimeStampSequenceHash, document);
            hashes.add(documentMessageDigest.getValue());
        }
        return hashes;
    }

    protected ASN1ArchiveTimeStampSequenceDigestHelper getEvidenceRecordRenewalDigestBuilderHelper() {
        return new ASN1ArchiveTimeStampSequenceDigestHelper((ASN1EvidenceRecord)this.evidenceRecord);
    }
}

