/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.EvidenceRecordTimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformation;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformationType;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordTimestampScopeFinder;
import eu.europa.esig.dss.spi.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EvidenceRecordTimestampSource<ER extends DefaultEvidenceRecord>
extends AbstractTimestampSource {
    private static final Logger LOG = LoggerFactory.getLogger(EvidenceRecordTimestampSource.class);
    protected final ER evidenceRecord;
    protected ListRevocationSource<CRL> crlSource;
    protected ListRevocationSource<OCSP> ocspSource;
    protected ListCertificateSource certificateSource;
    protected List<TimestampToken> timestamps;
    protected List<EvidenceRecord> detachedEvidenceRecords;

    protected EvidenceRecordTimestampSource(ER evidenceRecord) {
        Objects.requireNonNull(evidenceRecord, "The evidence record cannot be null!");
        this.evidenceRecord = evidenceRecord;
    }

    public List<TimestampToken> getTimestamps() {
        if (this.timestamps == null) {
            this.createAndValidate();
        }
        return this.timestamps;
    }

    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        if (this.detachedEvidenceRecords == null) {
            this.createAndValidate();
        }
        return this.detachedEvidenceRecords;
    }

    public void addExternalEvidenceRecord(EvidenceRecord evidenceRecord) {
        if (this.detachedEvidenceRecords == null) {
            this.createAndValidate();
        }
        this.processExternalEvidenceRecord(evidenceRecord);
        this.detachedEvidenceRecords.add(evidenceRecord);
    }

    protected void createAndValidate() {
        this.timestamps = new ArrayList<TimestampToken>();
        this.detachedEvidenceRecords = new ArrayList<EvidenceRecord>();
        this.crlSource = new ListRevocationSource<CRL>(((DefaultEvidenceRecord)this.evidenceRecord).getCRLSource());
        this.ocspSource = new ListRevocationSource<OCSP>(((DefaultEvidenceRecord)this.evidenceRecord).getOCSPSource());
        this.certificateSource = new ListCertificateSource(((DefaultEvidenceRecord)this.evidenceRecord).getCertificateSource());
        List<TimestampedReference> signerDataReferences = this.getSignerDataReferences();
        ArrayList<TimestampedReference> erValidationDataReferences = new ArrayList<TimestampedReference>();
        ArrayList<TimestampedReference> previousTimestampReferences = new ArrayList<TimestampedReference>();
        ArrayList<TimestampedReference> previousChainTimestampReferences = new ArrayList<TimestampedReference>();
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : ((DefaultEvidenceRecord)this.evidenceRecord).getArchiveTimeStampSequence()) {
            this.addReferences(references, signerDataReferences);
            this.addReference(references, this.getEvidenceRecordReference());
            this.addReferences(references, previousChainTimestampReferences);
            previousChainTimestampReferences = new ArrayList();
            for (ArchiveTimeStampObject archiveTimeStampObject : archiveTimeStampChainObject.getArchiveTimeStamps()) {
                this.addReferences(references, previousTimestampReferences);
                this.addReferences(references, erValidationDataReferences);
                previousTimestampReferences = new ArrayList();
                TimestampToken timestampToken = this.createTimestampToken(archiveTimeStampObject, this.getEvidenceRecordTimestampType(archiveTimeStampObject));
                timestampToken.getTimestampedReferences().addAll(references);
                timestampToken.setTimestampScopes(this.findTimestampScopes(timestampToken));
                this.populateSources(timestampToken);
                this.timestamps.add(timestampToken);
                List<TimestampedReference> encapsulatedTimestampReferences = this.getEncapsulatedReferencesFromTimestamp(timestampToken);
                this.addReferences(previousTimestampReferences, encapsulatedTimestampReferences);
                this.addReferences(previousChainTimestampReferences, encapsulatedTimestampReferences);
                List<CryptographicInformation> cryptographicInformationList = archiveTimeStampObject.getCryptographicInformationList();
                this.addReferences(erValidationDataReferences, this.getEncapsulatedReferencesFromCryptographicInformationList(cryptographicInformationList));
                references = new ArrayList();
            }
        }
    }

    private EvidenceRecordTimestampType getEvidenceRecordTimestampType(ArchiveTimeStampObject archiveTimeStamp) {
        ArchiveTimeStampChainObject firstArchiveTimeStampChain = ((DefaultEvidenceRecord)this.evidenceRecord).getArchiveTimeStampSequence().get(0);
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : ((DefaultEvidenceRecord)this.evidenceRecord).getArchiveTimeStampSequence()) {
            ArchiveTimeStampObject firstArchiveTimeStamp = archiveTimeStampChainObject.getArchiveTimeStamps().get(0);
            if (firstArchiveTimeStamp != archiveTimeStamp) continue;
            if (firstArchiveTimeStampChain == archiveTimeStampChainObject) {
                return EvidenceRecordTimestampType.ARCHIVE_TIMESTAMP;
            }
            return EvidenceRecordTimestampType.HASH_TREE_RENEWAL_ARCHIVE_TIMESTAMP;
        }
        return EvidenceRecordTimestampType.TIMESTAMP_RENEWAL_ARCHIVE_TIMESTAMP;
    }

    protected TimestampToken createTimestampToken(ArchiveTimeStampObject archiveTimeStamp, EvidenceRecordTimestampType evidenceRecordTimestampType) {
        TimestampToken timestampToken = archiveTimeStamp.getTimestampToken();
        timestampToken.setEvidenceRecordTimestampType(evidenceRecordTimestampType);
        return timestampToken;
    }

    protected TimestampedReference getEvidenceRecordReference() {
        return new TimestampedReference(((DefaultEvidenceRecord)this.evidenceRecord).getId(), TimestampedObjectType.EVIDENCE_RECORD);
    }

    protected List<TimestampedReference> getSignerDataReferences() {
        List<SignatureScope> evidenceRecordScopes = ((DefaultEvidenceRecord)this.evidenceRecord).getEvidenceRecordScopes();
        if (Utils.isCollectionEmpty(evidenceRecordScopes)) {
            return Collections.emptyList();
        }
        return this.getSignerDataTimestampedReferences(evidenceRecordScopes);
    }

    protected List<TimestampedReference> getEncapsulatedReferencesFromTimestamp(TimestampToken timestampToken) {
        return this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource);
    }

    protected List<SignatureScope> findTimestampScopes(TimestampToken timestampToken) {
        return new EvidenceRecordTimestampScopeFinder((EvidenceRecord)this.evidenceRecord).findTimestampScope(timestampToken);
    }

    private void processExternalEvidenceRecord(EvidenceRecord externalEvidenceRecord) {
        this.addReference(externalEvidenceRecord.getTimestampedReferences(), this.getEvidenceRecordReference());
        this.addReferences(externalEvidenceRecord.getTimestampedReferences(), ((DefaultEvidenceRecord)this.evidenceRecord).getTimestampedReferences());
        this.addReferences(externalEvidenceRecord.getTimestampedReferences(), this.getEncapsulatedReferencesFromTimestamps(this.getTimestamps()));
        this.populateSources(externalEvidenceRecord);
    }

    protected List<TimestampedReference> getEncapsulatedReferencesFromTimestamps(List<TimestampToken> timestampTokens) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (TimestampToken timestampToken : timestampTokens) {
            this.addReferences(references, this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource));
        }
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedReferencesFromCryptographicInformationList(List<CryptographicInformation> cryptographicInformationList) {
        if (Utils.isCollectionEmpty(cryptographicInformationList)) {
            return Collections.emptyList();
        }
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<CertificateToken> certificateTokens = this.getEncapsulatedCertificateTokens(cryptographicInformationList);
        this.addReferences(references, this.createReferencesForCertificates(certificateTokens));
        List<CRLBinary> crlBinaries = this.getEncapsulatedCRLBinaries(cryptographicInformationList);
        this.addReferences(references, this.createReferencesForCRLBinaries(crlBinaries));
        List<OCSPResponseBinary> ocspBinaries = this.getEncapsulatedOCSPBinaries(cryptographicInformationList);
        this.addReferences(references, this.createReferencesForOCSPBinaries(ocspBinaries, this.certificateSource));
        return references;
    }

    private List<CertificateToken> getEncapsulatedCertificateTokens(List<CryptographicInformation> cryptographicInformationList) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
            if (CryptographicInformationType.CERT != cryptographicInformation.getType()) continue;
            try {
                CertificateToken certificateToken = DSSUtils.loadCertificate(cryptographicInformation.getContent());
                certificateTokens.add(certificateToken);
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateTokens;
    }

    private List<CRLBinary> getEncapsulatedCRLBinaries(List<CryptographicInformation> cryptographicInformationList) {
        ArrayList<CRLBinary> crlBinaries = new ArrayList<CRLBinary>();
        for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
            if (CryptographicInformationType.CRL != cryptographicInformation.getType()) continue;
            try {
                CRLBinary crlBinary = CRLUtils.buildCRLBinary(cryptographicInformation.getContent());
                crlBinaries.add(crlBinary);
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated CRL : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return crlBinaries;
    }

    private List<OCSPResponseBinary> getEncapsulatedOCSPBinaries(List<CryptographicInformation> cryptographicInformationList) {
        ArrayList<OCSPResponseBinary> ocspBinaries = new ArrayList<OCSPResponseBinary>();
        for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
            if (CryptographicInformationType.OCSP != cryptographicInformation.getType()) continue;
            try {
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries(cryptographicInformation.getContent());
                OCSPResponseBinary ocspResponseBinary = OCSPResponseBinary.build(basicOCSPResp);
                ocspBinaries.add(ocspResponseBinary);
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated OCSP : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return ocspBinaries;
    }

    protected void populateSources(TimestampToken timestampToken) {
        if (timestampToken != null) {
            this.certificateSource.add(timestampToken.getCertificateSource());
            this.crlSource.add(timestampToken.getCRLSource());
            this.ocspSource.add(timestampToken.getOCSPSource());
        }
    }

    protected void populateSources(EvidenceRecord externalEvidenceRecord) {
        if (externalEvidenceRecord != null) {
            this.certificateSource.add(externalEvidenceRecord.getCertificateSource());
            this.crlSource.add(externalEvidenceRecord.getCRLSource());
            this.ocspSource.add(externalEvidenceRecord.getOCSPSource());
            for (TimestampToken timestampToken : externalEvidenceRecord.getTimestamps()) {
                this.populateSources(timestampToken);
            }
        }
    }
}

