/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.common.validation.timestamp.EvidenceRecordTimestampSource;
import eu.europa.esig.dss.evidencerecord.xml.validation.XMLEvidenceRecordAnalyzer;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.xml.validation.timestamp.XMLEvidenceRecordTimestampSource;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmlers.XMLEvidenceRecordUtils;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;

public class XmlEvidenceRecord
extends DefaultEvidenceRecord {
    private final Element evidenceRecordElement;

    public XmlEvidenceRecord(DSSDocument document) {
        Objects.requireNonNull(document, "Document cannot be null!");
        this.evidenceRecordElement = XmlEvidenceRecord.getEvidenceRecordElement(document);
    }

    private static Element getEvidenceRecordElement(DSSDocument document) {
        Element evidenceRecordElement = new XMLEvidenceRecordAnalyzer(document).getEvidenceRecordElement();
        if (evidenceRecordElement == null) {
            throw new IllegalInputException("The provided document shall be an XML Evidence Record!");
        }
        return evidenceRecordElement;
    }

    public XmlEvidenceRecord(Element evidenceRecordElement) {
        Objects.requireNonNull(evidenceRecordElement, "Evidence Record Element cannot be null!");
        this.evidenceRecordElement = evidenceRecordElement;
    }

    public Element getEvidenceRecordElement() {
        return this.evidenceRecordElement;
    }

    @Override
    protected EvidenceRecordParser buildEvidenceRecordParser() {
        return new XmlEvidenceRecordParser(this.evidenceRecordElement).setFilename(this.getFilename()).setEmbeddedEvidenceRecordHelper(this.getEmbeddedEvidenceRecordHelper());
    }

    @Override
    protected EvidenceRecordTimeStampSequenceVerifier buildCryptographicEvidenceRecordVerifier() {
        return new XmlEvidenceRecordTimeStampSequenceVerifier(this);
    }

    @Override
    protected EvidenceRecordTimestampSource<?> buildTimestampSource() {
        return new XMLEvidenceRecordTimestampSource(this);
    }

    @Override
    public List<String> validateStructure() {
        return XMLEvidenceRecordUtils.getInstance().validateAgainstXSD(new DOMSource(this.evidenceRecordElement));
    }

    @Override
    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return EvidenceRecordTypeEnum.XML_EVIDENCE_RECORD;
    }

    @Override
    public byte[] getEncoded() {
        return DomUtils.serializeNode(this.evidenceRecordElement);
    }
}

