/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ValidationDataEncapsulationStrategy;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineLT;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class JAdESLevelBaselineLTA
extends JAdESLevelBaselineLT {
    public JAdESLevelBaselineLTA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        super.extendSignatures(signatures, params);
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(params);
        signatureRequirementsChecker.assertSignaturesValid(signatures);
        boolean addTimestampValidationData = false;
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), params.isBase64UrlEncodedEtsiUComponents());
            this.assertExtendSignatureToLTAPossible(jadesSignature, params);
            if (!jadesSignature.hasLTAProfile()) continue;
            addTimestampValidationData = true;
        }
        ValidationDataContainer validationDataContainer = null;
        if (addTimestampValidationData) {
            validationDataContainer = this.documentValidator.getValidationData(signatures);
        }
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            if (jadesSignature.hasLTAProfile() && addTimestampValidationData) {
                this.removeLastTimestampAndAnyValidationData(jadesSignature, etsiUHeader);
                ValidationData includedValidationData = this.incorporateValidationDataForTimestamps(validationDataContainer, signature, etsiUHeader, params);
                this.incorporateAnyValidationData(validationDataContainer, signature, etsiUHeader, params, includedValidationData);
            }
            this.incorporateArcTst(jadesSignature, etsiUHeader, params);
        }
    }

    private ValidationData incorporateValidationDataForTimestamps(ValidationDataContainer validationDataContainer, AdvancedSignature signature, JAdESEtsiUHeader etsiUHeader, JAdESSignatureParameters signatureParameters) {
        ValidationData validationData;
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = signatureParameters.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                this.incorporateTstValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                this.incorporateTstValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                validationData = new ValidationData();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", new Object[]{validationDataEncapsulationStrategy}));
            }
        }
        return validationData;
    }

    private void incorporateAnyValidationData(ValidationDataContainer validationDataContainer, AdvancedSignature signature, JAdESEtsiUHeader etsiUHeader, JAdESSignatureParameters signatureParameters, ValidationData validationDataToExclude) {
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = signatureParameters.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignaturesForInclusion(signature));
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                ValidationData validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", new Object[]{validationDataEncapsulationStrategy}));
            }
        }
    }

    private void incorporateArcTst(JAdESSignature signature, JAdESEtsiUHeader etsiUHeader, JAdESSignatureParameters signatureParameters) {
        TimestampBinary timestampBinary = this.getArchiveTimestamp(signature, signatureParameters);
        JsonObject arcTst = DSSJsonUtils.getTstContainer(Collections.singletonList(timestampBinary), signatureParameters.getArchiveTimestampParameters().getCanonicalizationMethod());
        etsiUHeader.addComponent("arcTst", arcTst, signatureParameters.isBase64UrlEncodedEtsiUComponents());
    }

    private TimestampBinary getArchiveTimestamp(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        JAdESTimestampParameters archiveTimestampParameters = params.getArchiveTimestampParameters();
        DigestAlgorithm digestAlgorithmForTimestampRequest = archiveTimestampParameters.getDigestAlgorithm();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        DSSMessageDigest messageDigest = jadesSignature.getTimestampSource().getArchiveTimestampData(digestAlgorithmForTimestampRequest, canonicalizationMethod);
        return this.tspSource.getTimeStampResponse(digestAlgorithmForTimestampRequest, messageDigest.getValue());
    }

    private void assertExtendSignatureToLTAPossible(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        this.checkArchiveTimestampParameters(params);
        this.assertDetachedDocumentsContainBinaries(params);
        this.checkEtsiUContentUnicity(jadesSignature);
    }

    private void checkArchiveTimestampParameters(JAdESSignatureParameters params) {
        JAdESTimestampParameters archiveTimestampParameters = params.getArchiveTimestampParameters();
        if (!params.isBase64UrlEncodedEtsiUComponents() && Utils.isStringEmpty(archiveTimestampParameters.getCanonicalizationMethod())) {
            throw new IllegalInputException("Unable to extend JAdES-LTA level. Clear 'etsiU' incorporation requires a canonicalization method!");
        }
    }

    private void assertDetachedDocumentsContainBinaries(JAdESSignatureParameters params) {
        List<DSSDocument> detachedContents = params.getDetachedContents();
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                if (!(detachedDocument instanceof DigestDocument)) continue;
                throw new IllegalArgumentException("JAdES-LTA requires complete binaries of signed documents! Extension with a DigestDocument is not possible.");
            }
        }
    }

    private void checkEtsiUContentUnicity(JAdESSignature jadesSignature) {
        List<Object> etsiU = DSSJsonUtils.getEtsiU(jadesSignature.getJws());
        if (!DSSJsonUtils.checkComponentsUnicity(etsiU)) {
            throw new IllegalInputException("Unsupported 'etsiU' container structure! Extension is not possible.");
        }
    }
}

