/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JAdESRevocationRefExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESRevocationRefExtractionUtils.class);

    private JAdESRevocationRefExtractionUtils() {
    }

    public static OCSPRef createOCSPRef(Map<?, ?> ocpRef) {
        ResponderId responderId = null;
        Date producedAt = null;
        try {
            Digest digest;
            Map ocspId = (Map)ocpRef.get("ocspId");
            if (Utils.isMapNotEmpty(ocspId)) {
                producedAt = DSSJsonUtils.getDate((String)ocspId.get("producedAt"));
                responderId = JAdESRevocationRefExtractionUtils.getResponderId(ocspId);
            }
            if ((digest = DSSJsonUtils.getDigest(ocpRef)) != null) {
                return new OCSPRef(digest, producedAt, responderId);
            }
            LOG.warn("Missing digest information in OCSPRef");
        }
        catch (Exception e) {
            LOG.warn("Unable to extract OCSPRef. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private static ResponderId getResponderId(Map<?, ?> ocspId) {
        Map responderIdMap = (Map)ocspId.get("responderId");
        if (Utils.isMapNotEmpty(responderIdMap)) {
            String byKeyB64;
            X500Principal subjectX500Principal = null;
            byte[] ski = null;
            String byNameB64 = (String)responderIdMap.get("byName");
            if (Utils.isStringNotEmpty(byNameB64) && Utils.isBase64Encoded(byNameB64)) {
                subjectX500Principal = DSSASN1Utils.toX500Principal(X500Name.getInstance(Utils.fromBase64(byNameB64)));
            }
            if (Utils.isStringNotEmpty(byKeyB64 = (String)responderIdMap.get("byKey")) && Utils.isBase64Encoded(byKeyB64)) {
                ski = Utils.fromBase64(byKeyB64);
            }
            if (subjectX500Principal != null || Utils.isArrayNotEmpty(ski)) {
                return new ResponderId(subjectX500Principal, ski);
            }
        }
        return null;
    }

    public static CRLRef createCRLRef(Map<?, ?> crlRefMap) {
        X500Name crlIssuer = null;
        Date crlIssuedTime = null;
        BigInteger crlNumber = null;
        try {
            Digest digest;
            Map crlId = (Map)crlRefMap.get("crlId");
            if (Utils.isMapNotEmpty(crlId)) {
                String crlNumberString;
                String issueTimeStr;
                String issuerB64 = (String)crlId.get("issuer");
                if (Utils.isStringNotEmpty(issuerB64) && Utils.isBase64Encoded(issuerB64)) {
                    crlIssuer = X500Name.getInstance(Utils.fromBase64(issuerB64));
                }
                if (Utils.isStringNotEmpty(issueTimeStr = (String)crlId.get("issueTime"))) {
                    crlIssuedTime = DSSJsonUtils.getDate(issueTimeStr);
                }
                if (Utils.isStringNotEmpty(crlNumberString = (String)crlId.get("number"))) {
                    crlNumber = BigInteger.valueOf(Long.parseLong(crlNumberString));
                }
            }
            if ((digest = DSSJsonUtils.getDigest(crlRefMap)) != null) {
                CRLRef crlRef = new CRLRef(digest);
                crlRef.setCrlIssuer(crlIssuer);
                crlRef.setCrlIssuedTime(crlIssuedTime);
                crlRef.setCrlNumber(crlNumber);
                return crlRef;
            }
            LOG.warn("Missing digest information in CRLRef");
        }
        catch (Exception e) {
            LOG.warn("Unable to extract a CRLRef. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

