/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.jades.validation.JAdESCRLSource;
import eu.europa.esig.dss.jades.validation.JAdESCertificateSource;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESOCSPSource;
import eu.europa.esig.dss.jades.validation.JAdESReferenceValidation;
import eu.europa.esig.dss.jades.validation.JAdESSignatureIdentifierBuilder;
import eu.europa.esig.dss.jades.validation.JAdESSignatureIntegrityValidator;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.jades.validation.scope.JAdESSignatureScopeFinder;
import eu.europa.esig.dss.jades.validation.timestamp.JAdESTimestampSource;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignatureCryptographicVerification;
import eu.europa.esig.dss.model.signature.SignatureDigestReference;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignatureProductionPlace;
import eu.europa.esig.dss.model.signature.SignerRole;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.signature.identifier.SignatureIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = -3730351687600398811L;
    private static final Logger LOG = LoggerFactory.getLogger(JAdESSignature.class);
    private final JWS jws;
    private final boolean isDetached;
    private EtsiUComponent masterCSigComponent;
    private JAdESEtsiUHeader etsiUHeader;

    public JAdESSignature(JWS jws) {
        this.jws = jws;
        this.isDetached = Utils.isArrayEmpty(jws.getUnverifiedPayloadBytes());
    }

    public JWS getJws() {
        return this.jws;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.JAdES;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forJWA(this.jws.getAlgorithmHeaderValue(), null);
        if (signatureAlgorithm == null) {
            LOG.warn("SignatureAlgorithm '{}' is not supported!", (Object)this.jws.getAlgorithmHeaderValue());
        } else if (EncryptionAlgorithm.EDDSA.equals(signatureAlgorithm.getEncryptionAlgorithm())) {
            signatureAlgorithm = DSSUtils.getEdDSASignatureAlgorithm(this.getSignatureValue());
        }
        return signatureAlgorithm;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    @Override
    public Date getSigningTime() {
        Number iat = this.jws.getProtectedHeaderValueAsNumber("iat");
        String sigT = this.jws.getProtectedHeaderValueAsString("sigT");
        if (iat != null && Utils.isStringNotEmpty(sigT)) {
            LOG.debug("Unable to extract claimed signing-time: Conflict between 'iat' and 'sigT' header parameters! Only one shall be present.");
            return null;
        }
        if (iat != null) {
            long timeValueInMilliseconds = DSSJsonUtils.getTimeValueInMilliseconds(iat.longValue());
            return DSSJsonUtils.getDate(timeValueInMilliseconds);
        }
        if (Utils.isStringNotEmpty(sigT)) {
            return DSSJsonUtils.getDate(sigT);
        }
        LOG.debug("Unable to extract claimed signing-time: No signing-time identifying header was found.");
        return null;
    }

    public boolean isDetachedSignature() {
        return this.isDetached;
    }

    public EtsiUComponent getMasterCSigComponent() {
        return this.masterCSigComponent;
    }

    public void setMasterCSigComponent(EtsiUComponent masterCSigComponent) {
        this.masterCSigComponent = masterCSigComponent;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new JAdESCertificateSource(this.jws, this.getEtsiUHeader());
        }
        return this.offlineCertificateSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new JAdESCRLSource(this.getEtsiUHeader());
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new JAdESOCSPSource(this.getEtsiUHeader());
        }
        return this.signatureOCSPSource;
    }

    @Override
    public JAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new JAdESTimestampSource(this);
        }
        return (JAdESTimestampSource)this.signatureTimestampSource;
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        Map<?, ?> signaturePlace = this.jws.getProtectedHeaderValueAsMap("sigPl");
        if (Utils.isMapNotEmpty(signaturePlace)) {
            SignatureProductionPlace result = new SignatureProductionPlace();
            result.setCity(DSSJsonUtils.getAsString(signaturePlace, "addressLocality"));
            result.setStreetAddress(DSSJsonUtils.getAsString(signaturePlace, "streetAddress"));
            result.setPostOfficeBoxNumber(DSSJsonUtils.getAsString(signaturePlace, "postOfficeBoxNumber"));
            result.setPostalCode(DSSJsonUtils.getAsString(signaturePlace, "postalCode"));
            result.setStateOrProvince(DSSJsonUtils.getAsString(signaturePlace, "addressRegion"));
            result.setCountryName(DSSJsonUtils.getAsString(signaturePlace, "addressCountry"));
            return result;
        }
        return null;
    }

    @Override
    public SignaturePolicyStore getSignaturePolicyStore() {
        try {
            Map<?, ?> sigPStMap = this.getUnsignedPropertyAsMap("sigPSt");
            if (Utils.isMapNotEmpty(sigPStMap)) {
                Object spDSpec;
                String sigPolLocalURI;
                SignaturePolicyStore signaturePolicyStore = new SignaturePolicyStore();
                String sigPolDocBase64 = DSSJsonUtils.getAsString(sigPStMap, "sigPolDoc");
                if (Utils.isStringNotEmpty(sigPolDocBase64)) {
                    InMemoryDocument policyContent = new InMemoryDocument(Utils.fromBase64(sigPolDocBase64));
                    signaturePolicyStore.setSignaturePolicyContent(policyContent);
                }
                if (Utils.isStringNotEmpty(sigPolLocalURI = DSSJsonUtils.getAsString(sigPStMap, "sigPolLocalURI"))) {
                    signaturePolicyStore.setSigPolDocLocalURI(sigPolLocalURI);
                }
                if ((spDSpec = sigPStMap.get("spDSpec")) != null) {
                    SpDocSpecification spDocSpecification = DSSJsonUtils.parseSPDocSpecification(spDSpec);
                    signaturePolicyStore.setSpDocSpecification(spDocSpecification);
                }
                return signaturePolicyStore;
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot read signature policy store : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        ArrayList<CommitmentTypeIndication> result = new ArrayList<CommitmentTypeIndication>();
        List<?> signedCommitments = this.jws.getProtectedHeaderValueAsList("srCms");
        if (Utils.isCollectionNotEmpty(signedCommitments)) {
            for (Object signedCommitment : signedCommitments) {
                Map<?, ?> commIdMap;
                Map<?, ?> signedCommitmentMap = DSSJsonUtils.toMap(signedCommitment);
                if (!Utils.isMapNotEmpty(signedCommitmentMap) || !Utils.isMapNotEmpty(commIdMap = DSSJsonUtils.getAsMap(signedCommitmentMap, "commId"))) continue;
                String uri = DSSJsonUtils.getAsString(commIdMap, "id");
                if (Utils.isStringNotBlank(uri = DSSUtils.getObjectIdentifierValue(uri))) {
                    CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(uri);
                    String desc = DSSJsonUtils.getAsString(commIdMap, "desc");
                    commitmentTypeIndication.setDescription(desc);
                    List<?> docRefs = DSSJsonUtils.getAsList(commIdMap, "docRefs");
                    commitmentTypeIndication.setDocumentReferences(DSSJsonUtils.toListOfStrings(docRefs));
                    result.add(commitmentTypeIndication);
                    continue;
                }
                LOG.warn("Id parameter in the OID with the value '{}' is not conformant! The entry is skipped.", (Object)uri);
            }
        }
        return result;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public String getMimeType() {
        List<String> ctys;
        String value = this.jws.getContentTypeHeaderValue();
        if (Utils.isStringEmpty(value) && Utils.isCollectionNotEmpty(ctys = this.getSignedDataContentTypeList())) {
            value = ctys.get(0);
        }
        if (Utils.isStringNotEmpty(value)) {
            return DSSJsonUtils.getMimeTypeString(value);
        }
        return null;
    }

    public String getSignatureType() {
        String value = this.jws.getProtectedHeaderValueAsString("typ");
        if (Utils.isStringNotEmpty(value)) {
            return DSSJsonUtils.getMimeTypeString(value);
        }
        return null;
    }

    @Override
    public List<SignerRole> getCertifiedSignerRoles() {
        List<?> certified;
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        Map<?, ?> signerAttributes = this.getSignerAttributes();
        if (Utils.isMapNotEmpty(signerAttributes) && Utils.isCollectionNotEmpty(certified = DSSJsonUtils.getAsList(signerAttributes, "certified"))) {
            for (Object certifiedItem : certified) {
                String certifiedVal = this.getCertifiedVal(certifiedItem);
                if (!Utils.isStringNotEmpty(certifiedVal)) continue;
                result.add(new SignerRole(certifiedVal, EndorsementType.CERTIFIED));
            }
        }
        return result;
    }

    private String getCertifiedVal(Object certifiedItem) {
        Map<?, ?> certifiedItemMap = DSSJsonUtils.toMap(certifiedItem, "certifiedAttrs");
        Map<?, ?> x509AttrCert = DSSJsonUtils.getAsMap(certifiedItemMap, "x509AttrCert");
        if (Utils.isMapNotEmpty(x509AttrCert)) {
            return DSSJsonUtils.getAsString(x509AttrCert, "val");
        }
        Map<?, ?> otherAttrCert = DSSJsonUtils.getAsMap(certifiedItemMap, "otherAttrCert");
        if (Utils.isMapNotEmpty(otherAttrCert)) {
            LOG.warn("Unsupported {} found", (Object)"otherAttrCert");
            return null;
        }
        LOG.warn("One of types {} or {} is expected in {}", "x509AttrCert", "otherAttrCert", "certified");
        return null;
    }

    @Override
    public List<SignerRole> getClaimedSignerRoles() {
        List<?> claimed;
        Map<?, ?> signerAttributes = this.getSignerAttributes();
        if (Utils.isMapNotEmpty(signerAttributes) && Utils.isCollectionNotEmpty(claimed = DSSJsonUtils.getAsList(signerAttributes, "claimed"))) {
            return this.getQArraySignerRoles(claimed, EndorsementType.CLAIMED);
        }
        return Collections.emptyList();
    }

    @Override
    public List<SignerRole> getSignedAssertions() {
        List<?> signedAssertions;
        Map<?, ?> signerAttributes = this.getSignerAttributes();
        if (Utils.isMapNotEmpty(signerAttributes) && Utils.isCollectionNotEmpty(signedAssertions = DSSJsonUtils.getAsList(signerAttributes, "signedAssertions"))) {
            return this.getQArraySignerRoles(signedAssertions, EndorsementType.SIGNED);
        }
        return Collections.emptyList();
    }

    private List<SignerRole> getQArraySignerRoles(List<?> qArrays, EndorsementType category) {
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        if (Utils.isCollectionNotEmpty(qArrays)) {
            for (Object qArray : qArrays) {
                Map<?, ?> qArrayMap = DSSJsonUtils.toMap(qArray);
                List<?> vals = DSSJsonUtils.getAsList(qArrayMap, "qVals");
                for (Object val : vals) {
                    result.add(new SignerRole(val.toString(), category));
                }
            }
        }
        return result;
    }

    private Map<?, ?> getSignerAttributes() {
        return this.jws.getProtectedHeaderValueAsMap("srAts");
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        if (this.counterSignatures != null) {
            return this.counterSignatures;
        }
        this.counterSignatures = new ArrayList();
        List<EtsiUComponent> etsiUComponents = this.getEtsiUHeader().getAttributes();
        if (Utils.isCollectionNotEmpty(etsiUComponents)) {
            for (EtsiUComponent etsiUComponent : etsiUComponents) {
                JAdESSignature counterSignature;
                if (!"cSig".equals(etsiUComponent.getHeaderName()) || (counterSignature = DSSJsonUtils.extractJAdESCounterSignature(etsiUComponent, this)) == null) continue;
                counterSignature.setFilename(this.getFilename());
                this.counterSignatures.add(counterSignature);
            }
        }
        return this.counterSignatures;
    }

    @Override
    public String getDAIdentifier() {
        return null;
    }

    @Override
    protected SignaturePolicy buildSignaturePolicy() {
        Map<?, ?> policyId;
        Map<?, ?> sigPolicy = this.jws.getProtectedHeaderValueAsMap("sigPId");
        if (Utils.isMapNotEmpty(sigPolicy) && Utils.isMapNotEmpty(policyId = DSSJsonUtils.getAsMap(sigPolicy, "id"))) {
            Boolean digPSp;
            String id = DSSJsonUtils.getAsString(policyId, "id");
            this.signaturePolicy = new SignaturePolicy(DSSUtils.getObjectIdentifierValue(id));
            String desc = DSSJsonUtils.getAsString(policyId, "desc");
            this.signaturePolicy.setDescription(desc);
            List<?> docRefs = DSSJsonUtils.getAsList(policyId, "docRefs");
            this.signaturePolicy.setDocumentationReferences(DSSJsonUtils.toListOfStrings(docRefs));
            this.signaturePolicy.setDigest(DSSJsonUtils.getDigest(sigPolicy));
            List<?> qualifiers = DSSJsonUtils.getAsList(sigPolicy, "sigPQuals");
            if (Utils.isCollectionNotEmpty(qualifiers)) {
                this.signaturePolicy.setUri(this.getSPUri(qualifiers));
                this.signaturePolicy.setUserNotice(this.getSPUserNotice(qualifiers));
                this.signaturePolicy.setDocSpecification(this.getSPDSpec(qualifiers));
            }
            if ((digPSp = DSSJsonUtils.getAsBoolean(sigPolicy, "digPSp")) != null) {
                this.signaturePolicy.setHashAsInTechnicalSpecification(digPSp);
            }
        }
        return this.signaturePolicy;
    }

    private String getSPUri(List<?> qualifiers) {
        for (Object qualifier : qualifiers) {
            String spUri;
            Map<?, ?> qualifierMap = DSSJsonUtils.toMap(qualifier, "sigPQual");
            if (!Utils.isMapNotEmpty(qualifierMap) || !Utils.isStringNotEmpty(spUri = DSSJsonUtils.getAsString(qualifierMap, "spURI"))) continue;
            return spUri;
        }
        return null;
    }

    private UserNotice getSPUserNotice(List<?> qualifiers) {
        for (Object qualifier : qualifiers) {
            Map<?, ?> spUserNotice;
            Map<?, ?> qualifierMap = DSSJsonUtils.toMap(qualifier, "sigPQual");
            if (!Utils.isMapNotEmpty(qualifierMap) || !Utils.isMapNotEmpty(spUserNotice = DSSJsonUtils.getAsMap(qualifierMap, "spUserNotice"))) continue;
            try {
                String explTest;
                UserNotice userNotice = new UserNotice();
                Map<?, ?> noticeRef = DSSJsonUtils.getAsMap(spUserNotice, "noticeRef");
                if (Utils.isMapNotEmpty(noticeRef)) {
                    List<?> noticeNumbers;
                    String organization = DSSJsonUtils.getAsString(noticeRef, "organization");
                    if (Utils.isStringNotBlank(organization)) {
                        userNotice.setOrganization(organization);
                    }
                    if (Utils.isCollectionNotEmpty(noticeNumbers = DSSJsonUtils.getAsList(noticeRef, "noticeNumbers"))) {
                        userNotice.setNoticeNumbers(DSSJsonUtils.toListOfNumbers(noticeNumbers).stream().mapToInt(Number::intValue).toArray());
                    }
                }
                if (Utils.isStringNotBlank(explTest = DSSJsonUtils.getAsString(spUserNotice, "explText"))) {
                    userNotice.setExplicitText(explTest);
                }
                return userNotice;
            }
            catch (Exception e) {
                LOG.warn("Unable to build SPUserNotice qualifier. Reason : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
        return null;
    }

    private SpDocSpecification getSPDSpec(List<?> qualifiers) {
        for (Object qualifier : qualifiers) {
            Object spDSpec;
            Map<?, ?> qualifierMap = DSSJsonUtils.toMap(qualifier, "sigPQual");
            if (!Utils.isMapNotEmpty(qualifierMap) || (spDSpec = qualifierMap.get("spDSpec")) == null) continue;
            return DSSJsonUtils.parseSPDocSpecification(spDSpec);
        }
        return null;
    }

    @Override
    public byte[] getSignatureValue() {
        return this.jws.getSignatureValue();
    }

    public JAdESEtsiUHeader getEtsiUHeader() {
        if (this.etsiUHeader == null) {
            this.etsiUHeader = new JAdESEtsiUHeader(this.jws);
        }
        return this.etsiUHeader;
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        String encodedHeader = this.jws.getEncodedHeader();
        String payload = this.jws.isRfc7797UnencodedPayload() ? this.jws.getUnverifiedPayload() : this.jws.getEncodedPayload();
        String encodedSignature = this.jws.getEncodedSignature();
        byte[] signatureReferenceBytes = DSSJsonUtils.concatenate(encodedHeader, payload, encodedSignature).getBytes();
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, signatureReferenceBytes);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    @Override
    public Digest getDataToBeSignedRepresentation() {
        List<ReferenceValidation> referenceValidations = this.getReferenceValidations();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!DigestMatcherType.JWS_SIGNING_INPUT_DIGEST.equals((Object)referenceValidation.getType())) continue;
            return referenceValidation.isFound() ? referenceValidation.getDigest() : null;
        }
        throw new DSSException("JWS_SIGNING_INPUT_DIGEST is not found! Unable to compute DTBSR.");
    }

    @Override
    protected SignatureIdentifierBuilder getSignatureIdentifierBuilder() {
        return new JAdESSignatureIdentifierBuilder(this);
    }

    @Override
    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        boolean refsFound = false;
        boolean refsIntact = false;
        List<ReferenceValidation> referenceValidations = this.getReferenceValidations();
        if (Utils.isCollectionNotEmpty(referenceValidations)) {
            refsFound = true;
            refsIntact = true;
            for (ReferenceValidation referenceValidation : referenceValidations) {
                if (DigestMatcherType.JWS_SIGNING_INPUT_DIGEST.equals((Object)referenceValidation.getType())) {
                    JAdESReferenceValidation signingInputReferenceValidation = (JAdESReferenceValidation)referenceValidation;
                    this.signatureCryptographicVerification.setSignatureIntact(signingInputReferenceValidation.isIntact());
                    for (String errorMessage : signingInputReferenceValidation.getErrorMessages()) {
                        this.signatureCryptographicVerification.setErrorMessage(errorMessage);
                    }
                }
                refsFound = refsFound && referenceValidation.isFound();
                refsIntact = refsIntact && referenceValidation.isIntact();
            }
        }
        this.signatureCryptographicVerification.setReferenceDataFound(refsFound);
        this.signatureCryptographicVerification.setReferenceDataIntact(refsIntact);
    }

    @Override
    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            List<JAdESReferenceValidation> detachedReferenceValidations;
            this.referenceValidations = new ArrayList();
            JAdESReferenceValidation signingInputReferenceValidation = this.getSigningInputReferenceValidation();
            this.referenceValidations.add(signingInputReferenceValidation);
            if (this.isDetachedSignature() && Utils.isCollectionNotEmpty(detachedReferenceValidations = this.getDetachedReferenceValidations())) {
                this.referenceValidations.addAll(detachedReferenceValidations);
            }
            if (this.isCounterSignature()) {
                this.referenceValidations.add(this.getCounterSignatureReferenceValidation());
            }
        }
        return this.referenceValidations;
    }

    private JAdESReferenceValidation getSigningInputReferenceValidation() {
        JAdESReferenceValidation signatureValueReferenceValidation;
        block17: {
            signatureValueReferenceValidation = new JAdESReferenceValidation();
            signatureValueReferenceValidation.setType(DigestMatcherType.JWS_SIGNING_INPUT_DIGEST);
            try {
                String encodedHeader = this.jws.getEncodedHeader();
                if (!Utils.isStringNotEmpty(encodedHeader)) break block17;
                try {
                    byte[] payload;
                    SigDMechanism sigDMechanism = this.getSigDMechanism();
                    boolean detachedContentPresent = Utils.isCollectionNotEmpty(this.detachedContents);
                    if (!this.isDetachedSignature()) {
                        signatureValueReferenceValidation.setFound(true);
                    } else if (sigDMechanism == null && detachedContentPresent) {
                        payload = this.getIncorporatedPayload();
                        this.jws.setPayloadOctets(payload);
                        signatureValueReferenceValidation.setFound(this.detachedContents.size() == 1);
                    } else if (SigDMechanism.HTTP_HEADERS.equals(sigDMechanism)) {
                        payload = this.getPayloadForHttpHeadersMechanism();
                        this.jws.setPayloadOctets(payload);
                        signatureValueReferenceValidation.setFound(payload != null);
                    } else if (SigDMechanism.OBJECT_ID_BY_URI.equals(sigDMechanism)) {
                        payload = this.getPayloadForObjectIdByUriMechanism();
                        this.jws.setPayloadOctets(payload);
                        signatureValueReferenceValidation.setFound(payload != null);
                    } else if (SigDMechanism.OBJECT_ID_BY_URI_HASH.equals(sigDMechanism)) {
                        signatureValueReferenceValidation.setFound(true);
                    } else {
                        LOG.warn("The payload is not found! The detached content must be provided!");
                    }
                }
                catch (Exception e) {
                    String errorMessage = "Unable to determine a JWS payload. Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
                SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
                if (signatureAlgorithm != null) {
                    byte[] dataToSign = DSSJsonUtils.getSigningInputBytes(this.jws);
                    DigestAlgorithm digestAlgorithm = signatureAlgorithm.getDigestAlgorithm();
                    Digest digest = new Digest(digestAlgorithm, DSSUtils.digest(digestAlgorithm, dataToSign));
                    signatureValueReferenceValidation.setDigest(digest);
                    this.jws.setDoKeyValidation(false);
                    CandidatesForSigningCertificate candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
                    JAdESSignatureIntegrityValidator signingCertificateValidator = new JAdESSignatureIntegrityValidator(this.jws);
                    CertificateValidity certificateValidity = signingCertificateValidator.validate(candidatesForSigningCertificate);
                    if (certificateValidity != null) {
                        candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
                    }
                    List<String> errorMessages = signingCertificateValidator.getErrorMessages();
                    signatureValueReferenceValidation.setErrorMessages(errorMessages);
                    signatureValueReferenceValidation.setIntact(certificateValidity != null);
                }
            }
            catch (Exception e) {
                LOG.warn("The validation of signed input failed! Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return signatureValueReferenceValidation;
    }

    public String getKid() {
        return this.jws.getKeyIdHeaderValue();
    }

    private List<JAdESReferenceValidation> getDetachedReferenceValidations() {
        SigDMechanism sigDMechanism = this.getSigDMechanism();
        if (sigDMechanism != null) {
            switch (sigDMechanism) {
                case HTTP_HEADERS: 
                case OBJECT_ID_BY_URI: {
                    break;
                }
                case OBJECT_ID_BY_URI_HASH: {
                    return this.getReferenceValidationsByUriHashMechanism();
                }
                default: {
                    LOG.warn("The SigDMechanism '{}' is not supported!", (Object)sigDMechanism);
                }
            }
        }
        return Collections.emptyList();
    }

    public SigDMechanism getSigDMechanism() {
        Map<?, ?> signatureDetached = this.jws.getProtectedHeaderValueAsMap("sigD");
        if (Utils.isMapNotEmpty(signatureDetached)) {
            String mechanismUri = DSSJsonUtils.getAsString(signatureDetached, "mId");
            SigDMechanism sigDMechanism = SigDMechanism.forUri(mechanismUri);
            if (sigDMechanism == null) {
                LOG.warn("The sigDMechanism with uri '{}' is not supported!", (Object)mechanismUri);
            }
            return sigDMechanism;
        }
        return null;
    }

    private byte[] getIncorporatedPayload() {
        return DSSJsonUtils.getDocumentOctets((DSSDocument)this.detachedContents.get(0), !this.jws.isRfc7797UnencodedPayload());
    }

    private byte[] getPayloadForHttpHeadersMechanism() {
        if (Utils.isCollectionEmpty(this.detachedContents)) {
            throw new IllegalArgumentException("The detached contents shall be provided for validating a detached signature!");
        }
        List<DSSDocument> documentsByUri = this.getSignedDocumentsByHTTPHeaderName();
        HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(documentsByUri, false);
        return httpHeadersPayloadBuilder.build();
    }

    public List<DSSDocument> getSignedDocumentsByHTTPHeaderName() {
        List<String> signedDataUriList = this.getSignedDataUriList();
        if (Utils.isCollectionEmpty(this.detachedContents)) {
            LOG.warn("Detached content is not provided!");
            return Collections.emptyList();
        }
        if (signedDataUriList.size() == 1 && this.detachedContents.size() == 1) {
            return this.detachedContents;
        }
        ArrayList<DSSDocument> signedDocuments = new ArrayList<DSSDocument>();
        for (String signedDataName : signedDataUriList) {
            boolean found = false;
            for (DSSDocument document : this.detachedContents) {
                if (!Utils.areStringsEqualIgnoreCase(signedDataName, document.getName())) continue;
                found = true;
                signedDocuments.add(document);
            }
            if (found) continue;
            throw new IllegalArgumentException(String.format("The detached content for a signed data with name '%s' has not been found!", signedDataName));
        }
        return signedDocuments;
    }

    private byte[] getPayloadForObjectIdByUriMechanism() {
        if (Utils.isCollectionEmpty(this.detachedContents)) {
            throw new IllegalArgumentException("The detached contents shall be provided for validating a detached signature!");
        }
        List<DSSDocument> signedDocumentsByUri = this.getSignedDocumentsForObjectIdByUriMechanism();
        return DSSJsonUtils.concatenateDSSDocuments(signedDocumentsByUri, !this.jws.isRfc7797UnencodedPayload());
    }

    public List<DSSDocument> getSignedDocumentsForObjectIdByUriMechanism() {
        List<String> signedDataUriList = this.getSignedDataUriList();
        List<DSSDocument> signedDocumentsByUri = Collections.emptyList();
        if (Utils.collectionSize(signedDataUriList) == 1 && Utils.collectionSize(this.detachedContents) == 1) {
            signedDocumentsByUri = Collections.singletonList((DSSDocument)this.detachedContents.iterator().next());
        } else if (Utils.isCollectionNotEmpty(signedDataUriList)) {
            signedDocumentsByUri = new ArrayList<DSSDocument>();
            for (String signedDataName : signedDataUriList) {
                DSSDocument detachedDocumentByName = this.getDetachedDocumentByName(signedDataName, this.detachedContents);
                if (detachedDocumentByName != null) {
                    signedDocumentsByUri.add(detachedDocumentByName);
                    continue;
                }
                throw new IllegalArgumentException(String.format("The detached content for a signed data with name '%s' has not been found!", signedDataName));
            }
        }
        return signedDocumentsByUri;
    }

    private List<JAdESReferenceValidation> getReferenceValidationsByUriHashMechanism() {
        Map<String, String> signedDataHashMap;
        List<DSSDocument> detachedDocuments = this.detachedContents;
        if (Utils.isCollectionEmpty(this.detachedContents)) {
            LOG.warn("The detached content is not provided! Validation of '{}' is not possible.", (Object)"sigD");
            detachedDocuments = Collections.emptyList();
        }
        if (Utils.isMapEmpty(signedDataHashMap = this.getSignedDataUriHashMap())) {
            LOG.warn("The SignedData has not been found or incorrect for detached content.");
            JAdESReferenceValidation emptyReference = new JAdESReferenceValidation();
            emptyReference.setType(DigestMatcherType.SIG_D_ENTRY);
            return Collections.singletonList(emptyReference);
        }
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForDetachedContent();
        if (digestAlgorithm == null) {
            LOG.warn("The DigestAlgorithm has not been found for the detached content.");
        }
        ArrayList<JAdESReferenceValidation> detachedReferenceValidations = new ArrayList<JAdESReferenceValidation>();
        for (Map.Entry<String, String> signedDataEntry : signedDataHashMap.entrySet()) {
            DSSDocument detachedDocument;
            JAdESReferenceValidation referenceValidation = new JAdESReferenceValidation();
            referenceValidation.setType(DigestMatcherType.SIG_D_ENTRY);
            String signedDataName = signedDataEntry.getKey();
            referenceValidation.setUri(signedDataName);
            String expectedDigestString = signedDataEntry.getValue();
            byte[] expectedDigest = DSSJsonUtils.fromBase64Url(expectedDigestString);
            if (digestAlgorithm != null) {
                referenceValidation.setDigest(new Digest(digestAlgorithm, expectedDigest));
            }
            if (Utils.collectionSize(signedDataHashMap.entrySet()) == 1 && Utils.collectionSize(detachedDocuments) == 1) {
                detachedDocument = detachedDocuments.iterator().next();
            } else {
                detachedDocument = this.getDetachedDocumentByDigest(digestAlgorithm, expectedDigest, detachedDocuments);
                if (detachedDocument == null) {
                    detachedDocument = this.getDetachedDocumentByName(signedDataName, detachedDocuments);
                }
            }
            if (detachedDocument != null) {
                referenceValidation.setFound(true);
                referenceValidation.setDocumentName(detachedDocument.getName());
                if (digestAlgorithm != null && this.isDocumentDigestMatch(detachedDocument, digestAlgorithm, expectedDigest)) {
                    referenceValidation.setIntact(true);
                }
            } else {
                LOG.warn("A detached document for the '{}' header with name '{}' has not been found!", (Object)"sigD", (Object)signedDataName);
            }
            detachedReferenceValidations.add(referenceValidation);
        }
        if (Utils.isCollectionEmpty(detachedReferenceValidations)) {
            JAdESReferenceValidation referenceValidation = new JAdESReferenceValidation();
            referenceValidation.setType(DigestMatcherType.SIG_D_ENTRY);
            detachedReferenceValidations.add(referenceValidation);
        }
        return detachedReferenceValidations;
    }

    private DigestAlgorithm getDigestAlgorithmForDetachedContent() {
        try {
            Map<?, ?> signatureDetached = this.jws.getProtectedHeaderValueAsMap("sigD");
            if (Utils.isMapNotEmpty(signatureDetached)) {
                String digestAlgoUri = DSSJsonUtils.getAsString(signatureDetached, "hashM");
                return DigestAlgorithm.forJAdES(digestAlgoUri);
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to extract DigestAlgorithm for '{}' element. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, "sigD", e.getMessage(), e);
            }
            LOG.warn(errorMessage, (Object)"sigD", (Object)e.getMessage());
        }
        return null;
    }

    private DSSDocument getDetachedDocumentByDigest(DigestAlgorithm digestAlgorithm, byte[] expectedDigest, List<DSSDocument> detachedContent) {
        if (digestAlgorithm == null || expectedDigest == null) {
            return null;
        }
        for (DSSDocument detachedDocument : detachedContent) {
            if (!this.isDocumentDigestMatch(detachedDocument, digestAlgorithm, expectedDigest)) continue;
            return detachedDocument;
        }
        return null;
    }

    private DSSDocument getDetachedDocumentByName(String documentName, List<DSSDocument> detachedContent) {
        documentName = DSSUtils.decodeURI(documentName);
        for (DSSDocument detachedDocument : detachedContent) {
            if (documentName == null || !documentName.equals(detachedDocument.getName())) continue;
            return detachedDocument;
        }
        return null;
    }

    private Map<String, String> getSignedDataUriHashMap() {
        LinkedHashMap<String, String> signedDataHashMap = new LinkedHashMap<String, String>();
        List<String> signedDataUriList = this.getSignedDataUriList();
        List<String> signedDataHashList = this.getSignedDataHashList();
        if (signedDataUriList.size() != signedDataHashList.size()) {
            LOG.warn("The size of 'pars' and 'hashV' dictionaries does not match! See '5.2.8 The sigD header parameter'.");
            return signedDataHashMap;
        }
        for (int ii = 0; ii < signedDataUriList.size(); ++ii) {
            signedDataHashMap.put(signedDataUriList.get(ii), signedDataHashList.get(ii));
        }
        return signedDataHashMap;
    }

    private List<String> getSignedDataUriList() {
        Map<?, ?> signatureDetached = this.jws.getProtectedHeaderValueAsMap("sigD");
        if (Utils.isMapNotEmpty(signatureDetached)) {
            List<?> pars = DSSJsonUtils.getAsList(signatureDetached, "pars");
            return DSSJsonUtils.toListOfStrings(pars);
        }
        return Collections.emptyList();
    }

    private List<String> getSignedDataHashList() {
        Map<?, ?> signatureDetached = this.jws.getProtectedHeaderValueAsMap("sigD");
        if (Utils.isMapNotEmpty(signatureDetached)) {
            List<?> pars = DSSJsonUtils.getAsList(signatureDetached, "hashV");
            return DSSJsonUtils.toListOfStrings(pars);
        }
        return Collections.emptyList();
    }

    private List<String> getSignedDataContentTypeList() {
        Map<?, ?> signatureDetached = this.jws.getProtectedHeaderValueAsMap("sigD");
        if (Utils.isMapNotEmpty(signatureDetached)) {
            List<?> pars = DSSJsonUtils.getAsList(signatureDetached, "ctys");
            return DSSJsonUtils.toListOfStrings(pars);
        }
        return Collections.emptyList();
    }

    private boolean isDocumentDigestMatch(DSSDocument document, DigestAlgorithm digestAlgorithm, byte[] expectedDigest) {
        byte[] computedDigestValue;
        if (this.jws.isRfc7797UnencodedPayload() || document instanceof DigestDocument) {
            computedDigestValue = document.getDigestValue(digestAlgorithm);
        } else {
            String base64UrlEncodedDocument = DSSJsonUtils.toBase64Url(document);
            computedDigestValue = DSSUtils.digest(digestAlgorithm, base64UrlEncodedDocument.getBytes());
        }
        if (Arrays.equals(expectedDigest, computedDigestValue)) {
            return true;
        }
        LOG.warn("The computed digest '{}' from a document with name '{}' does not match one provided on the sigD : {}!", DSSJsonUtils.toBase64Url(computedDigestValue), document.getName(), DSSJsonUtils.toBase64Url(expectedDigest));
        return false;
    }

    private JAdESReferenceValidation getCounterSignatureReferenceValidation() {
        JAdESReferenceValidation referenceValidation = new JAdESReferenceValidation();
        referenceValidation.setType(DigestMatcherType.COUNTER_SIGNED_SIGNATURE_VALUE);
        JAdESSignature masterSignature = (JAdESSignature)this.getMasterSignature();
        if (masterSignature != null) {
            byte[] unverifiedPayloadBytes;
            byte[] signatureValue = masterSignature.getJws().getSignatureValue();
            if (Utils.isArrayNotEmpty(signatureValue)) {
                referenceValidation.setFound(true);
            }
            if (Utils.isArrayNotEmpty(unverifiedPayloadBytes = this.getJws().getUnverifiedPayloadBytes())) {
                boolean intact = Arrays.equals(signatureValue, unverifiedPayloadBytes);
                if (!intact) {
                    LOG.warn("The payload of a cSig with Id '{}' does not match the signature value of its master signature!", (Object)this.getDSSId().asXmlId());
                }
                referenceValidation.setIntact(intact);
            } else {
                referenceValidation.setIntact(true);
            }
        }
        return referenceValidation;
    }

    private Map<?, ?> getUnsignedPropertyAsMap(String headerName) {
        List<EtsiUComponent> unsignedPropertiesWithHeaderName = DSSJsonUtils.getUnsignedPropertiesWithHeaderName(this.getEtsiUHeader(), headerName);
        if (Utils.isCollectionNotEmpty(unsignedPropertiesWithHeaderName)) {
            return DSSJsonUtils.toMap(unsignedPropertiesWithHeaderName.iterator().next().getValue(), headerName);
        }
        return null;
    }

    public List<DSSDocument> getOriginalDocuments() {
        if (this.isDetachedSignature()) {
            SignatureCryptographicVerification signatureCryptographicVerification;
            ArrayList<DSSDocument> originalDocuments = new ArrayList<DSSDocument>();
            List<ReferenceValidation> referenceValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : referenceValidations) {
                String signedDataName;
                DSSDocument detachedDocument;
                if (!DigestMatcherType.SIG_D_ENTRY.equals((Object)referenceValidation.getType()) || !referenceValidation.isIntact() || (detachedDocument = this.getDetachedDocumentByName(signedDataName = DSSUtils.decodeURI(referenceValidation.getUri()), this.detachedContents)) == null) continue;
                originalDocuments.add(detachedDocument);
            }
            if (Utils.isCollectionEmpty(originalDocuments) && (signatureCryptographicVerification = this.getSignatureCryptographicVerification()).isSignatureIntact()) {
                if (Utils.isCollectionNotEmpty(this.detachedContents) && this.detachedContents.size() == 1) {
                    return Collections.singletonList((DSSDocument)this.detachedContents.get(0));
                }
                if (SigDMechanism.HTTP_HEADERS.equals(this.getSigDMechanism())) {
                    return this.getSignedDocumentsByHTTPHeaderName();
                }
                if (SigDMechanism.OBJECT_ID_BY_URI.equals(this.getSigDMechanism())) {
                    return this.getSignedDocumentsForObjectIdByUriMechanism();
                }
            }
            return originalDocuments;
        }
        byte[] payloadBytes = this.jws.getUnverifiedPayloadBytes();
        return Collections.singletonList(new InMemoryDocument(payloadBytes));
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        if (!this.hasBProfile()) {
            return SignatureLevel.JSON_NOT_ETSI;
        }
        if (!this.hasTProfile()) {
            return SignatureLevel.JAdES_BASELINE_B;
        }
        if (this.hasLTProfile()) {
            if (this.hasLTAProfile()) {
                return SignatureLevel.JAdES_BASELINE_LTA;
            }
            return SignatureLevel.JAdES_BASELINE_LT;
        }
        return SignatureLevel.JAdES_BASELINE_T;
    }

    @Override
    protected JAdESBaselineRequirementsChecker createBaselineRequirementsChecker(CertificateVerifier certificateVerifier) {
        return new JAdESBaselineRequirementsChecker(this, certificateVerifier);
    }

    @Override
    protected List<String> validateStructure() {
        List<String> validationErrors = DSSJsonUtils.validateAgainstJAdESSchema(this.jws);
        if (Utils.isCollectionNotEmpty(validationErrors)) {
            LOG.warn("Error(s) occurred during the JSON schema validation : {}", (Object)validationErrors);
        }
        return validationErrors;
    }

    @Override
    protected List<SignatureScope> findSignatureScopes() {
        return new JAdESSignatureScopeFinder().findSignatureScope(this);
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        throw new UnsupportedOperationException("The method addExternalTimestamp(timestamp) is not supported for JAdES!");
    }
}

