/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSCompactSerializationParser;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class JWSCompactDocumentAnalyzer
extends AbstractJWSDocumentAnalyzer {
    public JWSCompactDocumentAnalyzer() {
    }

    public JWSCompactDocumentAnalyzer(DSSDocument document) {
        super(document);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        JWSCompactSerializationParser parser = new JWSCompactSerializationParser(dssDocument);
        return parser.isSupported();
    }

    @Override
    protected List<AdvancedSignature> buildSignatures() {
        JWSJsonSerializationObject jwsJsonSerializationObject = this.getJwsJsonSerializationObject();
        List<JWS> foundSignatures = jwsJsonSerializationObject.getSignatures();
        if (Utils.isCollectionEmpty(foundSignatures)) {
            throw new DSSException("No signatures is present in the document!");
        }
        JWS jws = foundSignatures.get(0);
        JAdESSignature jadesSignature = new JAdESSignature(jws);
        jadesSignature.setFilename(this.document.getName());
        jadesSignature.setSigningCertificateSource(this.signingCertificateSource);
        jadesSignature.setDetachedContents(this.detachedContents);
        jadesSignature.initBaselineRequirementsChecker(this.certificateVerifier);
        this.validateSignaturePolicy(jadesSignature);
        return Collections.singletonList(jadesSignature);
    }

    @Override
    protected JWSJsonSerializationObject buildJwsJsonSerializationObject() {
        JWSCompactSerializationParser jwsCompactSerializationParser = new JWSCompactSerializationParser(this.document);
        if (jwsCompactSerializationParser.isSupported()) {
            JWS jws = jwsCompactSerializationParser.parse();
            JWSJsonSerializationObject jwsJsonSerializationObject = DSSJsonUtils.toJWSJsonSerializationObject(jws);
            jwsJsonSerializationObject.setJWSSerializationType(JWSSerializationType.COMPACT_SERIALIZATION);
            return jwsJsonSerializationObject;
        }
        throw new IllegalInputException("The given document is not supported by JWSCompactDocumentValidator!");
    }
}

