/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.tsl;

import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import java.io.Serializable;
import java.util.List;

public class TLValidationJobSummary
implements Serializable {
    private static final long serialVersionUID = -1035891155378415013L;
    private final List<LOTLInfo> lotlInfos;
    private final List<TLInfo> otherTLInfos;

    public TLValidationJobSummary(List<LOTLInfo> lotlInfos, List<TLInfo> otherTLInfos) {
        if ((lotlInfos == null || lotlInfos.isEmpty()) && (otherTLInfos == null || otherTLInfos.isEmpty())) {
            throw new IllegalArgumentException("LOTL or TL Info shall be provided!");
        }
        this.lotlInfos = lotlInfos;
        this.otherTLInfos = otherTLInfos;
    }

    public List<LOTLInfo> getLOTLInfos() {
        return this.lotlInfos;
    }

    public List<TLInfo> getOtherTLInfos() {
        return this.otherTLInfos;
    }

    public int getNumberOfProcessedTLs() {
        int amount = 0;
        if (this.otherTLInfos != null && !this.otherTLInfos.isEmpty()) {
            amount += this.otherTLInfos.size();
        }
        if (this.lotlInfos != null && !this.lotlInfos.isEmpty()) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                amount += lotlInfo.getTLInfos().size();
            }
        }
        return amount;
    }

    public int getNumberOfProcessedLOTLs() {
        if (this.lotlInfos != null && !this.lotlInfos.isEmpty()) {
            return this.lotlInfos.size();
        }
        return 0;
    }

    public TLInfo getTLInfoById(Identifier identifier) {
        if (this.otherTLInfos != null && !this.otherTLInfos.isEmpty()) {
            for (TLInfo tlInfo : this.otherTLInfos) {
                if (!identifier.equals(tlInfo.getDSSId())) continue;
                return tlInfo;
            }
        }
        if (this.lotlInfos != null && !this.lotlInfos.isEmpty()) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                if (lotlInfo.getTLInfos() == null || lotlInfo.getTLInfos().isEmpty()) continue;
                for (TLInfo tlInfo : lotlInfo.getTLInfos()) {
                    if (!identifier.equals(tlInfo.getDSSId())) continue;
                    return tlInfo;
                }
            }
        }
        return null;
    }

    public LOTLInfo getLOTLInfoById(Identifier identifier) {
        if (this.lotlInfos != null && !this.lotlInfos.isEmpty()) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                if (!identifier.equals(lotlInfo.getDSSId())) continue;
                return lotlInfo;
            }
        }
        return null;
    }
}

