/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import java.io.Serializable;
import java.util.Objects;

public class PdfSignatureField
implements Serializable {
    private static final long serialVersionUID = 1391102373661984177L;
    private final String fieldName;
    private final SigFieldPermissions lockDictionary;

    public PdfSignatureField(PdfDict sigFieldDict) {
        Objects.requireNonNull(sigFieldDict, "sigFieldDict cannot be null!");
        this.fieldName = PdfSignatureField.extractFieldName(sigFieldDict);
        this.lockDictionary = PdfSignatureField.extractLockDictionary(sigFieldDict);
    }

    private static String extractFieldName(PdfDict sigFieldDict) {
        return sigFieldDict.getStringValue("T");
    }

    private static SigFieldPermissions extractLockDictionary(PdfDict sigFieldDict) {
        PdfDict lock = sigFieldDict.getAsDict("Lock");
        if (lock != null) {
            return PAdESUtils.extractPermissionsDictionary(lock);
        }
        return null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SigFieldPermissions getLockDictionary() {
        return this.lockDictionary;
    }

    public String toString() {
        return "PdfSignatureField {name=" + this.getFieldName() + '}';
    }
}

