/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfSigDictWrapper;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSigDictWrapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PdfSigDictWrapperFactory.class);
    private final PdfDict sigFieldDictionary;

    public PdfSigDictWrapperFactory(PdfDict sigFieldDictionary) {
        this.sigFieldDictionary = sigFieldDictionary;
    }

    public PdfSigDictWrapper create() {
        PdfSigDictWrapper pdfSigDictWrapper = new PdfSigDictWrapper();
        pdfSigDictWrapper.setDictionary(this.sigFieldDictionary);
        pdfSigDictWrapper.setCMS(this.buildCMS());
        pdfSigDictWrapper.setSignerName(this.getSignerName());
        pdfSigDictWrapper.setSigningDate(this.getSigningDate());
        pdfSigDictWrapper.setContactInfo(this.getContactInfo());
        pdfSigDictWrapper.setReason(this.getReason());
        pdfSigDictWrapper.setLocation(this.getLocation());
        pdfSigDictWrapper.setSigningDate(this.getSigningDate());
        pdfSigDictWrapper.setType(this.getType());
        pdfSigDictWrapper.setFilter(this.getFilter());
        pdfSigDictWrapper.setSubFilter(this.getSubFilter());
        pdfSigDictWrapper.setContents(this.getContents());
        pdfSigDictWrapper.setByteRange(this.getByteRange());
        pdfSigDictWrapper.setDocMDP(this.getDocMDP());
        pdfSigDictWrapper.setFieldMDP(this.getFieldMDP());
        return pdfSigDictWrapper;
    }

    private CMS buildCMS() {
        return CMSUtils.parseToCMS(this.getContents());
    }

    private String getSignerName() {
        return this.sigFieldDictionary.getStringValue("Name");
    }

    private String getContactInfo() {
        return this.sigFieldDictionary.getStringValue("ContactInfo");
    }

    private String getReason() {
        return this.sigFieldDictionary.getStringValue("Reason");
    }

    private String getLocation() {
        return this.sigFieldDictionary.getStringValue("Location");
    }

    private Date getSigningDate() {
        return this.sigFieldDictionary.getDateValue("M");
    }

    private String getType() {
        return this.sigFieldDictionary.getNameValue("Type");
    }

    private String getFilter() {
        return this.sigFieldDictionary.getNameValue("Filter");
    }

    private String getSubFilter() {
        return this.sigFieldDictionary.getNameValue("SubFilter");
    }

    private byte[] getContents() {
        try {
            return this.sigFieldDictionary.getBinariesValue("Contents");
        }
        catch (IOException e) {
            throw new DSSException("Unable to retrieve the signature content", e);
        }
    }

    private ByteRange getByteRange() {
        PdfArray byteRangeArray = this.sigFieldDictionary.getAsArray("ByteRange");
        if (byteRangeArray == null) {
            throw new DSSException(String.format("Unable to retrieve the '%s' field value.", "ByteRange"));
        }
        int arraySize = byteRangeArray.size();
        int[] result = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            result[i] = byteRangeArray.getNumber(i).intValue();
        }
        return new ByteRange(result);
    }

    private CertificationPermission getDocMDP() {
        PdfArray referenceArray = this.sigFieldDictionary.getAsArray("Reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                PdfDict sigRef = referenceArray.getAsDict(i);
                if (!"DocMDP".equals(sigRef.getNameValue("TransformMethod"))) continue;
                PdfDict transformParams = sigRef.getAsDict("TransformParams");
                if (transformParams == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"TransformParams", (Object)"DocMDP");
                    continue;
                }
                Number permissions = transformParams.getNumberValue("P");
                if (permissions == null) {
                    LOG.warn("No '{}' parameter found. Unable to perform a '{}' entry validation!", (Object)"P", (Object)"DocMDP");
                    continue;
                }
                return CertificationPermission.fromCode(permissions.intValue());
            }
        }
        return null;
    }

    private SigFieldPermissions getFieldMDP() {
        PdfArray referenceArray = this.sigFieldDictionary.getAsArray("Reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                PdfDict sigRef = referenceArray.getAsDict(i);
                if (!"FieldMDP".equals(sigRef.getNameValue("TransformMethod"))) continue;
                PdfDict dataDict = sigRef.getAsDict("Data");
                if (dataDict == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"Data", (Object)"FieldMDP");
                    continue;
                }
                String dataDictType = dataDict.getNameValue("Type");
                if (!"Catalog".equals(dataDictType)) {
                    LOG.warn("Unsupported type of '{}' dictionary found : '{}'. The '{}' validation skipped.", "Data", dataDictType, "FieldMDP");
                    continue;
                }
                PdfDict transformParams = sigRef.getAsDict("TransformParams");
                if (transformParams == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"TransformParams", (Object)"FieldMDP");
                    continue;
                }
                return PAdESUtils.extractPermissionsDictionary(transformParams);
            }
        }
        return null;
    }
}

