/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.status;

import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.validation.status.TokenStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RevocationFreshnessStatus
extends TokenStatus {
    private final Map<Token, Date> tokenRevocationNextUpdateMap = new HashMap<Token, Date>();

    public void addTokenAndRevocationNextUpdateTime(Token token, Date revocationNextUpdate) {
        this.tokenRevocationNextUpdateMap.put(token, revocationNextUpdate);
    }

    public Date getTokenRevocationNextUpdateTime(Token token) {
        return this.tokenRevocationNextUpdateMap.get(token);
    }

    public Date getMinimalNextUpdateTime() {
        Date minimalNextUpdate = null;
        for (Date nextUpdate : this.tokenRevocationNextUpdateMap.values()) {
            if (minimalNextUpdate != null && !minimalNextUpdate.before(nextUpdate)) continue;
            minimalNextUpdate = nextUpdate;
        }
        return minimalNextUpdate;
    }

    @Override
    public String getErrorString() {
        Date nextUpdateTime = this.getMinimalNextUpdateTime();
        return nextUpdateTime != null ? this.getMessage() + " NextUpdate time : " + DSSUtils.formatDateToRFC(nextUpdateTime) + " " + this.objectMapToString() : super.getErrorString();
    }
}

