/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.spi.x509.CertificateRefIdentifier;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.io.Serializable;
import java.util.Objects;

public class CertificateRef
implements IdentifierBasedObject,
Serializable {
    private static final long serialVersionUID = -325165164194282066L;
    private Digest certDigest;
    private SignerIdentifier signerIdentifier;
    private ResponderId responderId;
    private String x509Url;
    private Identifier identifier;

    public Digest getCertDigest() {
        return this.certDigest;
    }

    public void setCertDigest(Digest certDigest) {
        this.certDigest = certDigest;
    }

    public SignerIdentifier getCertificateIdentifier() {
        return this.signerIdentifier;
    }

    public void setCertificateIdentifier(SignerIdentifier signerIdentifier) {
        this.signerIdentifier = signerIdentifier;
    }

    public ResponderId getResponderId() {
        return this.responderId;
    }

    public void setResponderId(ResponderId responderId) {
        this.responderId = responderId;
    }

    public String getX509Url() {
        return this.x509Url;
    }

    public void setX509Url(String x509Url) {
        this.x509Url = x509Url;
    }

    @Override
    public Identifier getDSSId() {
        if (this.identifier == null) {
            this.identifier = new CertificateRefIdentifier(this);
        }
        return this.identifier;
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public String toString() {
        return "CertificateRef [certDigest=" + this.certDigest + ", signerIdentifier=" + this.signerIdentifier + ", responderId=" + this.responderId + ", x509Uri='" + this.x509Url + "']";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateRef)) {
            return false;
        }
        CertificateRef that = (CertificateRef)o;
        if (!Objects.equals(this.certDigest, that.certDigest)) {
            return false;
        }
        if (!Objects.equals(this.signerIdentifier, that.signerIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.responderId, that.responderId)) {
            return false;
        }
        return Objects.equals(this.x509Url, that.x509Url);
    }

    public int hashCode() {
        int result = this.certDigest != null ? this.certDigest.hashCode() : 0;
        result = 31 * result + (this.signerIdentifier != null ? this.signerIdentifier.hashCode() : 0);
        result = 31 * result + (this.responderId != null ? this.responderId.hashCode() : 0);
        result = 31 * result + (this.x509Url != null ? this.x509Url.hashCode() : 0);
        return result;
    }
}

