/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.fx.CollectionFilesToStringConverter;
import eu.europa.esig.dss.standalone.fx.DSSFileChooser;
import eu.europa.esig.dss.standalone.fx.DSSFileChooserLoader;
import eu.europa.esig.dss.standalone.fx.FileToStringConverter;
import eu.europa.esig.dss.standalone.model.ExtensionModel;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.standalone.source.TLValidationJobExecutor;
import eu.europa.esig.dss.standalone.task.ExtensionTask;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionController.class);
    @FXML
    public Button signedFileSelectButton;
    @FXML
    public Button originalFilesSelectButton;
    @FXML
    public RadioButton asicsRadio;
    @FXML
    public RadioButton asiceRadio;
    @FXML
    private ToggleGroup toggleAsicContainerType;
    @FXML
    public RadioButton xadesRadio;
    @FXML
    public RadioButton cadesRadio;
    @FXML
    public RadioButton padesRadio;
    @FXML
    public RadioButton jadesRadio;
    @FXML
    private ToggleGroup toogleSigFormat;
    @FXML
    public ComboBox<SignatureLevel> comboLevel;
    @FXML
    public Label warningMockTSALabel;
    @FXML
    public Button extendButton;
    @FXML
    public HBox refreshBox;
    @FXML
    public Button refreshLOTL;
    @FXML
    public Label nbCertificates;
    @FXML
    public Label warningLabel;
    private ExtensionModel model;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.model = new ExtensionModel();
        this.signedFileSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("File to extend");
                File fileToExtend = fileChooser.showOpenDialog(ExtensionController.this.stage);
                ExtensionController.this.model.setFileToExtend(fileToExtend);
            }
        });
        this.signedFileSelectButton.textProperty().bindBidirectional(this.model.fileToExtendProperty(), new FileToStringConverter());
        this.originalFilesSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Original file(s)");
                List<File> files = fileChooser.showOpenMultipleDialog(ExtensionController.this.stage);
                ExtensionController.this.model.setOriginalDocuments(files);
            }
        });
        this.originalFilesSelectButton.textProperty().bindBidirectional(this.model.originalDocumentsProperty(), new CollectionFilesToStringConverter());
        this.asicsRadio.setUserData((Object)ASiCContainerType.ASiC_S);
        this.asiceRadio.setUserData((Object)ASiCContainerType.ASiC_E);
        this.toggleAsicContainerType.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable2, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    ASiCContainerType newContainerType = (ASiCContainerType)((Object)newValue.getUserData());
                    ExtensionController.this.updateSignatureFormForASiC(newContainerType);
                } else {
                    ExtensionController.this.updateSignatureFormForASiC(null);
                }
            }
        });
        this.cadesRadio.setUserData((Object)SignatureForm.CAdES);
        this.xadesRadio.setUserData((Object)SignatureForm.XAdES);
        this.padesRadio.setUserData((Object)SignatureForm.PAdES);
        this.jadesRadio.setUserData((Object)SignatureForm.JAdES);
        this.toogleSigFormat.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable2, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    SignatureForm newSigForm = (SignatureForm)((Object)newValue.getUserData());
                    ExtensionController.this.updateSignatureForm(newSigForm);
                } else {
                    ExtensionController.this.updateSignatureForm(null);
                }
            }
        });
        this.comboLevel.valueProperty().bindBidirectional(this.model.signatureLevelProperty());
        final BooleanBinding disableExtendButton = this.model.fileToExtendProperty().isNull().or(this.model.signatureFormProperty().isNull()).or(this.model.signatureLevelProperty().isNull());
        this.extendButton.disableProperty().bind(disableExtendButton);
        this.extendButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                final Service<DSSDocument> service = new Service<DSSDocument>(){

                    @Override
                    protected Task<DSSDocument> createTask() {
                        return new ExtensionTask(ExtensionController.this.model, TLValidationJobExecutor.getInstance().getCertificateSources());
                    }
                };
                service.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        ExtensionController.this.save((DSSDocument)service.getValue());
                        ExtensionController.this.extendButton.disableProperty().bind(disableExtendButton);
                    }
                });
                service.setOnFailed(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        String errorMessage = "Oops an error occurred : " + service.getMessage();
                        LOG.error(errorMessage, service.getException());
                        Alert alert = new Alert(Alert.AlertType.ERROR, errorMessage, ButtonType.CLOSE);
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.showAndWait();
                        ExtensionController.this.extendButton.disableProperty().bind(disableExtendButton);
                    }
                });
                ExtensionController.this.extendButton.disableProperty().bind(service.runningProperty());
                service.start();
            }
        });
        this.warningMockTSALabel.setVisible(Utils.isTrue(PropertyReader.getBooleanProperty("timestamp.mock")));
    }

    protected void updateSignatureFormForASiC(ASiCContainerType newValue) {
        this.model.setAsicContainerType(newValue);
        this.reinitSignatureFormats();
        if (newValue != null) {
            this.cadesRadio.setDisable(false);
            this.xadesRadio.setDisable(false);
        } else {
            this.cadesRadio.setDisable(false);
            this.padesRadio.setDisable(false);
            this.xadesRadio.setDisable(false);
            this.jadesRadio.setDisable(false);
        }
    }

    private void reinitSignatureFormats() {
        this.cadesRadio.setDisable(true);
        this.padesRadio.setDisable(true);
        this.xadesRadio.setDisable(true);
        this.jadesRadio.setDisable(true);
        this.cadesRadio.setSelected(false);
        this.padesRadio.setSelected(false);
        this.xadesRadio.setSelected(false);
        this.jadesRadio.setSelected(false);
    }

    private void updateSignatureForm(SignatureForm signatureForm) {
        this.model.setSignatureForm(signatureForm);
        this.comboLevel.setDisable(false);
        this.comboLevel.getItems().removeAll((Collection<?>)this.comboLevel.getItems());
        if (signatureForm != null) {
            switch (signatureForm) {
                case CAdES: {
                    this.comboLevel.getItems().addAll((SignatureLevel[])new SignatureLevel[]{SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_BASELINE_LTA});
                    this.comboLevel.setValue(SignatureLevel.CAdES_BASELINE_T);
                    break;
                }
                case PAdES: {
                    this.comboLevel.getItems().addAll((SignatureLevel[])new SignatureLevel[]{SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PAdES_BASELINE_LTA});
                    this.comboLevel.setValue(SignatureLevel.PAdES_BASELINE_T);
                    break;
                }
                case XAdES: {
                    this.comboLevel.getItems().addAll((SignatureLevel[])new SignatureLevel[]{SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA});
                    this.comboLevel.setValue(SignatureLevel.XAdES_BASELINE_T);
                    break;
                }
                case JAdES: {
                    this.comboLevel.getItems().addAll((SignatureLevel[])new SignatureLevel[]{SignatureLevel.JAdES_BASELINE_T, SignatureLevel.JAdES_BASELINE_LT, SignatureLevel.JAdES_BASELINE_LTA});
                    this.comboLevel.setValue(SignatureLevel.JAdES_BASELINE_T);
                }
            }
        }
    }
}

