/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import eu.europa.esig.dss.token.SunPKCS11Initializer;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkcs11SignatureToken
extends AbstractKeyStoreTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Pkcs11SignatureToken.class);
    private static final String SUN_PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String NEW_LINE = "\n";
    private static final String DOUBLE_QUOTE = "\"";
    private Provider provider;
    private final String pkcs11Path;
    private final PasswordInputCallback callback;
    private final int slotId;
    private final int slotListIndex;
    private final String extraPkcs11Config;

    public Pkcs11SignatureToken(String pkcs11Path) {
        this(pkcs11Path, (PasswordInputCallback)null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, String extraPkcs11Config) {
        this(pkcs11Path, (PasswordInputCallback)null, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password) {
        this(pkcs11Path, password, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, String extraPkcs11Config) {
        this(pkcs11Path, password, 0, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback) {
        this(pkcs11Path, callback, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, String extraPkcs11Config) {
        this(pkcs11Path, callback, 0, -1, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, int slotId) {
        this(pkcs11Path, (PasswordInputCallback)new PrefilledPasswordCallback(password), slotId);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, int slotId, String extraPkcs11Config) {
        this(pkcs11Path, new PrefilledPasswordCallback(password), slotId, -1, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId) {
        this(pkcs11Path, callback, slotId, -1, null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId, String extraPkcs11Config) {
        this(pkcs11Path, callback, slotId, -1, extraPkcs11Config);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId, int slotListIndex, String extraPkcs11Config) {
        this.pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotId = slotId;
        this.slotListIndex = slotListIndex;
        this.extraPkcs11Config = extraPkcs11Config;
    }

    protected Provider getProvider() {
        if (this.provider == null) {
            String configString = this.buildConfig();
            LOG.debug("PKCS11 Config : \n{}", (Object)configString);
            this.provider = SunPKCS11Initializer.getProvider(configString);
            if (this.provider == null) {
                throw new DSSException("Unable to create PKCS11 provider");
            }
            Security.addProvider(this.provider);
        }
        return this.provider;
    }

    protected String buildConfig() {
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        StringBuilder pkcs11Config = new StringBuilder();
        pkcs11Config.append("name = SmartCard").append(UUID.randomUUID());
        pkcs11Config.append(NEW_LINE).append("library = ").append(DOUBLE_QUOTE).append(aPKCS11LibraryFileName).append(DOUBLE_QUOTE);
        if (this.slotId >= 0) {
            pkcs11Config.append(NEW_LINE).append("slot = ").append(this.slotId);
        }
        if (this.slotListIndex >= 0) {
            pkcs11Config.append(NEW_LINE).append("slotListIndex = ").append(this.slotListIndex);
        }
        if (this.extraPkcs11Config != null && !this.extraPkcs11Config.isEmpty()) {
            pkcs11Config.append(NEW_LINE).append(this.extraPkcs11Config);
        }
        return pkcs11Config.toString();
    }

    protected String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    @Override
    protected KeyStore getKeyStore() throws DSSException {
        try {
            KeyStore keyStore = KeyStore.getInstance(SUN_PKCS11_KEYSTORE_TYPE, this.getProvider());
            keyStore.load(() -> new KeyStore.CallbackHandlerProtection(callbacks -> {
                for (Callback c : callbacks) {
                    if (!(c instanceof PasswordCallback)) continue;
                    ((PasswordCallback)c).setPassword(this.callback.getPassword());
                    return;
                }
                throw new DSSException("No password callback");
            }));
            return keyStore;
        }
        catch (Exception e) {
            if ("CKR_PIN_INCORRECT".equals(e.getMessage())) {
                throw new DSSException("Bad password for PKCS11", e);
            }
            throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e.getMessage(), e);
        }
    }

    protected String getPkcs11Path() {
        return this.pkcs11Path;
    }

    @Override
    protected KeyStore.PasswordProtection getKeyProtectionParameter() {
        return null;
    }

    @Override
    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm, this.getProvider());
    }

    @Override
    public void close() {
        if (this.provider != null) {
            try {
                try {
                    if (this.provider instanceof AuthProvider) {
                        ((AuthProvider)this.provider).logout();
                    }
                }
                catch (LoginException e) {
                    LOG.error("Unable to logout : {}", (Object)e.getMessage(), (Object)e);
                }
                this.provider.clear();
                Security.removeProvider(this.provider.getName());
            }
            catch (SecurityException e) {
                LOG.error("Unable to remove provider '{}'", (Object)this.provider.getName(), (Object)e);
            }
            finally {
                this.provider = null;
            }
        }
    }
}

