/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto;

import eu.europa.esig.dss.enumerations.TSLType;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.TrustService;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.tsl.dto.AbstractCacheDTO;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;

public class ParsingCacheDTO
extends AbstractCacheDTO
implements ParsingInfoRecord {
    private static final long serialVersionUID = 5464908480606825440L;
    private TSLType tslType;
    private Integer sequenceNumber;
    private Integer version;
    private String territory;
    private Date issueDate;
    private Date nextUpdateDate;
    private List<String> distributionPoints;
    private List<TrustServiceProvider> trustServiceProviders;
    private List<OtherTSLPointer> lotlOtherPointers;
    private List<OtherTSLPointer> tlOtherPointers;
    private List<String> pivotUrls;
    private String signingCertificateAnnouncementUrl;
    protected List<String> structureValidationMessages;

    public ParsingCacheDTO() {
    }

    public ParsingCacheDTO(AbstractCacheDTO cacheDTO) {
        super(cacheDTO);
    }

    @Override
    public TSLType getTSLType() {
        return this.tslType;
    }

    public void setTSLType(TSLType tslType) {
        this.tslType = tslType;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String getTerritory() {
        return this.territory;
    }

    public void setTerritory(String territory) {
        this.territory = territory;
    }

    @Override
    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    @Override
    public Date getNextUpdateDate() {
        return this.nextUpdateDate;
    }

    public void setNextUpdateDate(Date nextUpdateDate) {
        this.nextUpdateDate = nextUpdateDate;
    }

    @Override
    public List<String> getDistributionPoints() {
        return this.distributionPoints;
    }

    public void setDistributionPoints(List<String> distributionPoints) {
        this.distributionPoints = distributionPoints;
    }

    @Override
    public List<TrustServiceProvider> getTrustServiceProviders() {
        return this.trustServiceProviders;
    }

    public void setTrustServiceProviders(List<TrustServiceProvider> trustServiceProviders) {
        this.trustServiceProviders = trustServiceProviders;
    }

    @Override
    public List<OtherTSLPointer> getLotlOtherPointers() {
        return this.lotlOtherPointers;
    }

    public void setLotlOtherPointers(List<OtherTSLPointer> lotlOtherPointers) {
        this.lotlOtherPointers = lotlOtherPointers;
    }

    @Override
    public List<OtherTSLPointer> getTlOtherPointers() {
        return this.tlOtherPointers;
    }

    public void setTlOtherPointers(List<OtherTSLPointer> tlOtherPointers) {
        this.tlOtherPointers = tlOtherPointers;
    }

    @Override
    public List<String> getPivotUrls() {
        return this.pivotUrls;
    }

    public void setPivotUrls(List<String> pivotUrls) {
        this.pivotUrls = pivotUrls;
    }

    @Override
    public String getSigningCertificateAnnouncementUrl() {
        return this.signingCertificateAnnouncementUrl;
    }

    public void setSigningCertificateAnnouncementUrl(String signingCertificateAnnouncementUrl) {
        this.signingCertificateAnnouncementUrl = signingCertificateAnnouncementUrl;
    }

    @Override
    public int getTSPNumber() {
        if (Utils.isCollectionNotEmpty(this.trustServiceProviders)) {
            return this.trustServiceProviders.size();
        }
        return 0;
    }

    @Override
    public int getTSNumber() {
        int tsNumber = 0;
        if (Utils.isCollectionNotEmpty(this.trustServiceProviders)) {
            for (TrustServiceProvider tsp : this.trustServiceProviders) {
                tsNumber += tsp.getServices().size();
            }
        }
        return tsNumber;
    }

    @Override
    public int getCertNumber() {
        int certNumber = 0;
        if (Utils.isCollectionNotEmpty(this.trustServiceProviders)) {
            for (TrustServiceProvider tsp : this.trustServiceProviders) {
                for (TrustService trustService : tsp.getServices()) {
                    certNumber += trustService.getCertificates().size();
                }
            }
        }
        return certNumber;
    }

    @Override
    public List<String> getStructureValidationMessages() {
        return this.structureValidationMessages;
    }

    public void setStructureValidationMessages(List<String> structureValidationMessages) {
        this.structureValidationMessages = structureValidationMessages;
    }
}

