/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.builder;

import eu.europa.esig.dss.enumerations.TSLType;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.builder.AbstractCacheDTOBuilder;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingResult;
import eu.europa.esig.dss.tsl.parsing.LOTLParsingResult;
import eu.europa.esig.dss.tsl.parsing.TLParsingResult;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingCacheDTOBuilder
extends AbstractCacheDTOBuilder<AbstractParsingResult> {
    private static final Logger LOG = LoggerFactory.getLogger(ParsingCacheDTOBuilder.class);

    public ParsingCacheDTOBuilder(CachedEntry<AbstractParsingResult> cachedEntry) {
        super(cachedEntry);
    }

    @Override
    public ParsingCacheDTO build() {
        ParsingCacheDTO parsingCacheDTO = new ParsingCacheDTO(super.build());
        if (this.isResultExist()) {
            parsingCacheDTO.setTSLType(this.getTSLType());
            parsingCacheDTO.setSequenceNumber(this.getSequenceNumber());
            parsingCacheDTO.setVersion(this.getVersion());
            parsingCacheDTO.setTerritory(this.getTerritory());
            parsingCacheDTO.setIssueDate(this.getIssueDate());
            parsingCacheDTO.setNextUpdateDate(this.getNextUpdateDate());
            parsingCacheDTO.setDistributionPoints(this.getDistributionPoints());
            parsingCacheDTO.setStructureValidationMessages(this.getStructureValidationMessages());
            if (this.isLOTL()) {
                parsingCacheDTO.setLotlOtherPointers(this.getLOTLOtherPointers());
                parsingCacheDTO.setTlOtherPointers(this.getTLOtherPointers());
                parsingCacheDTO.setPivotUrls(this.getPivotUrls());
                parsingCacheDTO.setSigningCertificateAnnouncementUrl(this.getSigningCertificateAnnouncementUrl());
            } else {
                parsingCacheDTO.setTrustServiceProviders(this.getTrustServiceProviders());
            }
        }
        return parsingCacheDTO;
    }

    private boolean isLOTL() {
        return this.getResult() instanceof LOTLParsingResult;
    }

    private TSLType getTSLType() {
        return ((AbstractParsingResult)this.getResult()).getTSLType();
    }

    private Integer getSequenceNumber() {
        return ((AbstractParsingResult)this.getResult()).getSequenceNumber();
    }

    private Integer getVersion() {
        return ((AbstractParsingResult)this.getResult()).getVersion();
    }

    private String getTerritory() {
        return ((AbstractParsingResult)this.getResult()).getTerritory();
    }

    private Date getIssueDate() {
        return ((AbstractParsingResult)this.getResult()).getIssueDate();
    }

    private Date getNextUpdateDate() {
        return ((AbstractParsingResult)this.getResult()).getNextUpdateDate();
    }

    private List<String> getDistributionPoints() {
        return ((AbstractParsingResult)this.getResult()).getDistributionPoints();
    }

    private List<String> getStructureValidationMessages() {
        return ((AbstractParsingResult)this.getResult()).getStructureValidationMessages();
    }

    private List<TrustServiceProvider> getTrustServiceProviders() {
        AbstractParsingResult result = (AbstractParsingResult)this.getResult();
        if (result instanceof TLParsingResult) {
            return ((TLParsingResult)this.getResult()).getTrustServiceProviders();
        }
        LOG.debug("Cannot extract trustServiceProviders for the entry. The parsed file is not a TL. Return empty list.");
        return Collections.emptyList();
    }

    private List<OtherTSLPointer> getLOTLOtherPointers() {
        AbstractParsingResult result = (AbstractParsingResult)this.getResult();
        if (result instanceof LOTLParsingResult) {
            return ((LOTLParsingResult)this.getResult()).getLotlPointers();
        }
        LOG.debug("Cannot extract LOTL other Pointers for the entry. The parsed file is not a LOTL. Return empty list.");
        return Collections.emptyList();
    }

    private List<OtherTSLPointer> getTLOtherPointers() {
        AbstractParsingResult result = (AbstractParsingResult)this.getResult();
        if (result instanceof LOTLParsingResult) {
            return ((LOTLParsingResult)this.getResult()).getTlPointers();
        }
        LOG.debug("Cannot extract TL other Pointers for the entry. The parsed file is not a LOTL. Return empty list.");
        return Collections.emptyList();
    }

    private List<String> getPivotUrls() {
        AbstractParsingResult result = (AbstractParsingResult)this.getResult();
        if (result instanceof LOTLParsingResult) {
            return ((LOTLParsingResult)this.getResult()).getPivotURLs();
        }
        LOG.debug("Cannot extract Pivot URLs for the entry. The parsed file is not a LOTL. Return empty list.");
        return Collections.emptyList();
    }

    private String getSigningCertificateAnnouncementUrl() {
        AbstractParsingResult result = (AbstractParsingResult)this.getResult();
        if (result instanceof LOTLParsingResult) {
            return ((LOTLParsingResult)this.getResult()).getSigningCertificateAnnouncementURL();
        }
        LOG.debug("Cannot extract Signing Certificate Announcement URL for the entry. The parsed file is not a LOTL. Return null.");
        return null;
    }
}

