/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractTimeStampPresentCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Collection<XmlTimestamp> xmlTimestamps;

    protected AbstractTimeStampPresentCheck(I18nProvider i18nProvider, T result, Map<String, XmlBasicBuildingBlocks> bbbs, Collection<XmlTimestamp> xmlTimestamps, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.bbbs = bbbs;
        this.xmlTimestamps = xmlTimestamps;
    }

    @Override
    protected boolean process() {
        for (TimestampWrapper timestamp : this.getTimestamps()) {
            XmlValidationProcessBasicTimestamp timestampBasicValidation = this.getTimestampBasicValidation(timestamp);
            if (timestampBasicValidation == null || !ValidationProcessUtils.isAllowedBasicTimestampValidation(timestampBasicValidation.getConclusion())) continue;
            if (this.isValidConclusion(timestampBasicValidation.getConclusion())) {
                return true;
            }
            XmlPSV tstPSV = this.getPastSignatureValidationForTimestamp(timestamp);
            if (tstPSV == null || !this.isValidConclusion(tstPSV.getConclusion())) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<TimestampWrapper> getTimestamps();

    private XmlValidationProcessBasicTimestamp getTimestampBasicValidation(TimestampWrapper timestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!timestamp.getId().equals(xmlTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessBasicTimestamp();
        }
        return null;
    }

    private XmlPSV getPastSignatureValidationForTimestamp(TimestampWrapper timestampWrapper) {
        XmlBasicBuildingBlocks tstBBB = this.bbbs.get(timestampWrapper.getId());
        if (tstBBB != null) {
            return tstBBB.getPSV();
        }
        return null;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

