/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestCryptographicCheckerResultCheck;
import java.util.Date;
import java.util.List;

public class DigestMatcherCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends DigestCryptographicCheckerResultCheck<T> {
    private final List<String> referenceNames;

    public DigestMatcherCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, MessageTag position, List<String> referenceNames, XmlCC ccResult, LevelRule constraint) {
        super(i18nProvider, result, validationDate, position, ccResult, constraint);
        this.referenceNames = referenceNames;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid(this.ccResult)) {
            if (Utils.collectionSize(this.referenceNames) == 0) {
                return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM, new Object[]{this.ccResult.getVerifiedAlgorithm().getName(), dateTime, this.position});
            }
            if (Utils.collectionSize(this.referenceNames) == 1) {
                return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM_WITH_NAME, new Object[]{this.ccResult.getVerifiedAlgorithm().getName(), dateTime, this.position, this.referenceNames.iterator().next()});
            }
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM_WITH_NAMES, new Object[]{this.ccResult.getVerifiedAlgorithm().getName(), dateTime, this.position, Utils.joinStrings(this.referenceNames, ", ")});
        }
        if (Utils.collectionSize(this.referenceNames) == 0) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF, this.getErrorMessage(), dateTime);
        }
        if (Utils.collectionSize(this.referenceNames) == 1) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF_WITH_NAME, this.getErrorMessage(), dateTime, this.referenceNames.iterator().next());
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF_WITH_NAMES, this.getErrorMessage(), dateTime, Utils.joinStrings(this.referenceNames, ", "));
    }
}

