/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeByCertificatePostEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeByCertificatePreEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeByTL;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;

public final class TypeStrategyFactory {
    private TypeStrategyFactory() {
    }

    public static TypeStrategy createTypeFromCert(CertificateWrapper signingCertificate) {
        if (EIDASUtils.isPostEIDAS(signingCertificate.getNotBefore())) {
            return new TypeByCertificatePostEIDAS(signingCertificate);
        }
        return new TypeByCertificatePreEIDAS(signingCertificate);
    }

    public static TypeStrategy createTypeFromTL(TrustServiceWrapper trustService, CertificateQualifiedStatus qualified, TypeStrategy typeInCert) {
        return new TypeByTL(trustService, qualified, typeInCert);
    }

    public static TypeStrategy createTypeFromCertAndTL(CertificateWrapper signingCertificate, TrustServiceWrapper caQcTrustService, CertificateQualifiedStatus qualified) {
        TypeStrategy typeFromCert = TypeStrategyFactory.createTypeFromCert(signingCertificate);
        return TypeStrategyFactory.createTypeFromTL(caQcTrustService, qualified, typeFromCert);
    }
}

