/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class SunsetDateCheck
extends ChainItem<XmlVTS> {
    private final CertificateWrapper trustedCertificate;

    public SunsetDateCheck(I18nProvider i18nProvider, XmlVTS result, CertificateWrapper trustedCertificate, LevelRule constraint) {
        super(i18nProvider, result, constraint, trustedCertificate.getId());
        this.trustedCertificate = trustedCertificate;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.SUB_XCV_TA;
    }

    @Override
    protected boolean process() {
        return this.trustedCertificate != null && this.trustedCertificate.getTrustSunsetDate() != null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ISDDTA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ISDDTA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.trustedCertificate != null && this.trustedCertificate.getTrustSunsetDate() != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_SUNSET_DATE_TRUST_ANCHOR, this.trustedCertificate.getId(), ValidationProcessUtils.getFormattedDate(this.trustedCertificate.getTrustSunsetDate()));
        }
        return null;
    }
}

