/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.utils.Utils;
import java.util.Objects;

public class XAdESTimestampParameters
extends TimestampParameters {
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public XAdESTimestampParameters() {
    }

    public XAdESTimestampParameters(DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
    }

    public XAdESTimestampParameters(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        super(digestAlgorithm);
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 4.5 Managing canonicalization of XML nodesets.");
        }
        this.canonicalizationMethod = canonicalizationMethod;
    }

    @Override
    public String toString() {
        return "XAdESTimestampParameters [canonicalizationMethod='" + this.canonicalizationMethod + '\'' + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XAdESTimestampParameters that = (XAdESTimestampParameters)o;
        return Objects.equals(this.canonicalizationMethod, that.canonicalizationMethod);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.canonicalizationMethod);
        return result;
    }
}

