/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.xades.reference.AbstractTransform;
import eu.europa.esig.dss.xades.reference.DSSTransformOutput;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ComplexTransform
extends AbstractTransform {
    private static final long serialVersionUID = -2344414065328072642L;
    private Transform transformObject;

    protected ComplexTransform(DSSNamespace xmlDSigNamespace, String algorithm) {
        super(xmlDSigNamespace, algorithm);
    }

    private Transform getTransformObject() {
        if (this.transformObject == null) {
            this.transformObject = this.buildTransformObject();
        }
        return this.transformObject;
    }

    protected Transform buildTransformObject() {
        try {
            Document document = DomUtils.buildDOM();
            Element transformsDom = DomUtils.createElementNS(document, this.namespace, XMLDSigElement.TRANSFORMS);
            document.appendChild(transformsDom);
            this.createTransform(document, transformsDom);
            NodeList childNodes = transformsDom.getFirstChild().getChildNodes();
            Transform transform = new Transform(document, this.algorithm, childNodes);
            for (Map.Entry<String, String> namespace : DomUtils.getCurrentNamespaces().entrySet()) {
                transform.setXPathNamespaceContext(namespace.getKey(), namespace.getValue());
            }
            return transform;
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Cannot initialize a transform [%s]", this.algorithm), e);
        }
    }

    @Override
    public DSSTransformOutput performTransform(DSSTransformOutput transformOutput) {
        try {
            Transform transform = this.getTransformObject();
            XMLSignatureInput xmlSignatureOutput = transform.performTransform(transformOutput.getXmlSignatureInput(), true);
            return new DSSTransformOutput(xmlSignatureOutput);
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException(String.format("Cannot process transformation [%s] on the given DOM object. Reason : [%s]", this.algorithm, e.getMessage()), e);
        }
    }
}

