/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.w3c.dom.Element;

public class XAdESLevelC
extends XAdESLevelBaselineT {
    public XAdESLevelC(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToCLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            this.xadesSignature.resetTimestampSource();
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        if (SignatureLevel.XAdES_C.equals((Object)this.params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToCLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForCLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = this.documentAnalyzer.getValidationData(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (signatureRequirementsChecker.hasXLevelOrHigher(signature)) continue;
            String indent = this.removeOldCertificateRefs();
            this.removeOldRevocationRefs();
            ValidationData validationDataForInclusion = this.getValidationDataForCLevelInclusion(validationDataContainer, signature);
            Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            this.incorporateCertificateRefs(this.unsignedSignaturePropertiesDom, validationDataForInclusion.getCertificateTokens(), indent);
            if (Utils.isCollectionNotEmpty(validationDataForInclusion.getCrlTokens()) || Utils.isCollectionNotEmpty(validationDataForInclusion.getOcspTokens())) {
                Element completeRevocationRefsDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCompleteRevocationRefs());
                this.incorporateCRLRefs(completeRevocationRefsDom, validationDataForInclusion.getCrlTokens());
                this.incorporateOCSPRefs(completeRevocationRefsDom, validationDataForInclusion.getOcspTokens());
            }
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }

    private List<AdvancedSignature> getExtendToCLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> signaturesToExtend = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.cLevelExtensionRequired(signature)) continue;
            signaturesToExtend.add(signature);
        }
        return signaturesToExtend;
    }

    private boolean cLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_C.equals((Object)this.params.getSignatureLevel()) || SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel()) || !signature.hasXProfile();
    }

    private String removeOldCertificateRefs() {
        String text = null;
        Element certRefs = DomUtils.getElement(this.xadesSignature.getSignatureElement(), this.xadesPath.getCompleteCertificateRefsPath());
        Element certRefsV2 = DomUtils.getElement(this.xadesSignature.getSignatureElement(), this.xadesPath.getCompleteCertificateRefsV2Path());
        if (certRefs != null || certRefsV2 != null) {
            text = this.removeNode(certRefs);
            if (text == null || certRefsV2 != null) {
                text = this.removeNode(certRefsV2);
            }
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    private void removeOldRevocationRefs() {
        Element toRemove = DomUtils.getElement(this.xadesSignature.getSignatureElement(), this.xadesPath.getCompleteRevocationRefsPath());
        if (toRemove != null) {
            this.removeNode(toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    private void incorporateCertificateRefs(Element parentDom, Collection<CertificateToken> certificatesToBeAdded, String indent) {
        if (Utils.isCollectionNotEmpty(certificatesToBeAdded)) {
            Element completeCertificateRefsDom = this.createCompleteCertificateRefsDom(parentDom);
            Element certRefsDom = this.createCertRefsDom(completeCertificateRefsDom);
            DigestAlgorithm tokenReferencesDigestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            for (CertificateToken certificateToken : certificatesToBeAdded) {
                this.incorporateCert(certRefsDom, certificateToken, tokenReferencesDigestAlgorithm);
            }
        }
    }

    private Element createCompleteCertificateRefsDom(Element parentDom) {
        if (this.params.isEn319132()) {
            return DomUtils.addElement(this.documentDom, parentDom, this.getXades141Namespace(), XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2);
        }
        return DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCompleteCertificateRefs());
    }

    private Element createCertRefsDom(Element parentDom) {
        if (this.params.isEn319132()) {
            return DomUtils.addElement(this.documentDom, parentDom, this.getXades141Namespace(), XAdES141Element.CERT_REFS);
        }
        return DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCertRefs());
    }

    private ValidationData getValidationDataForCLevelInclusion(ValidationDataContainer validationDataContainer, AdvancedSignature signature) {
        ValidationData validationData = validationDataContainer.getAllValidationDataForSignature(signature);
        validationData.excludeCertificateTokens(this.getCertificateTokensForExclusion());
        return validationData;
    }

    private Collection<CertificateToken> getCertificateTokensForExclusion() {
        CertificateToken signingCertificateToken = this.xadesSignature.getSigningCertificateToken();
        if (signingCertificateToken != null) {
            return Collections.singletonList(signingCertificateToken);
        }
        return Collections.emptyList();
    }

    private void incorporateCRLRefs(Element completeRevocationRefsDom, Collection<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlRefsDom = DomUtils.addElement(this.documentDom, completeRevocationRefsDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCRLRefs());
        for (CRLToken crlToken : crlTokens) {
            Element crlRefDom = DomUtils.addElement(this.documentDom, crlRefsDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCRLRef());
            DigestAlgorithm digestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            Element digestAlgAndValueDom = DomUtils.addElement(this.documentDom, crlRefDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, crlToken);
            Element crlIdentifierDom = DomUtils.addElement(this.documentDom, crlRefDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCRLIdentifier());
            String issuerX500PrincipalName = crlToken.getIssuerX500Principal().getName();
            DomUtils.addTextElement(this.documentDom, crlIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIssuer(), issuerX500PrincipalName);
            Date thisUpdate = crlToken.getThisUpdate();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(thisUpdate);
            String thisUpdateAsXmlFormat = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement(this.documentDom, crlIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIssueTime(), thisUpdateAsXmlFormat);
        }
    }

    private void incorporateOCSPRefs(Element completeRevocationRefsDom, Collection<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspRefsDom = DomUtils.addElement(this.documentDom, completeRevocationRefsDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementOCSPRefs());
        for (OCSPToken ocspToken : ocspTokens) {
            BasicOCSPResp basicOcspResp = ocspToken.getBasicOCSPResp();
            if (basicOcspResp == null) continue;
            Element ocspRefDom = DomUtils.addElement(this.documentDom, ocspRefsDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementOCSPRef());
            Element ocspIdentifierDom = DomUtils.addElement(this.documentDom, ocspRefDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementOCSPIdentifier());
            Element responderIDDom = DomUtils.addElement(this.documentDom, ocspIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementResponderID());
            RespID respID = basicOcspResp.getResponderId();
            ResponderId responderId = DSSRevocationUtils.getDSSResponderId(respID);
            if (responderId.getX500Principal() != null) {
                DomUtils.addTextElement(this.documentDom, responderIDDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementByName(), responderId.getX500Principal().toString());
            } else {
                String base64EncodedKeyHashOctetStringBytes = Utils.toBase64(responderId.getSki());
                DomUtils.addTextElement(this.documentDom, responderIDDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementByKey(), base64EncodedKeyHashOctetStringBytes);
            }
            Date producedAt = basicOcspResp.getProducedAt();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(producedAt);
            String producedAtXmlEncoded = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement(this.documentDom, ocspIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementProducedAt(), producedAtXmlEncoded);
            DigestAlgorithm digestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            Element digestAlgAndValueDom = DomUtils.addElement(this.documentDom, ocspRefDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, ocspToken);
        }
    }
}

