/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.io.InputStream;
import org.apache.xml.security.signature.XMLSignatureInput;

public class DSSDocumentXMLSignatureInput
extends XMLSignatureInput {
    private final DSSDocument document;
    private String preCalculatedDigest;

    public DSSDocumentXMLSignatureInput(DSSDocument document) {
        super(DSSDocumentXMLSignatureInput.toInputStream(document));
        this.document = document;
    }

    private static InputStream toInputStream(DSSDocument document) {
        return document.openStream();
    }

    protected DSSDocumentXMLSignatureInput(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        super(DSSDocumentXMLSignatureInput.getBase64Digest(document, digestAlgorithm));
        this.document = document;
        this.preCalculatedDigest = super.getPreCalculatedDigest();
    }

    private static String getBase64Digest(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        byte[] digestValue = document.getDigestValue(digestAlgorithm);
        return Utils.toBase64(digestValue);
    }

    @Override
    public String getMIMEType() {
        if (this.document.getMimeType() != null) {
            return this.document.getMimeType().getMimeTypeString();
        }
        return null;
    }

    public String getDocumentName() {
        return this.document.getName();
    }

    @Override
    public boolean isPreCalculatedDigest() {
        return this.preCalculatedDigest != null;
    }

    @Override
    public String getPreCalculatedDigest() {
        Utils.closeQuietly(this.getOctetStreamReal());
        return this.preCalculatedDigest;
    }

    public void setPreCalculatedDigest(String preCalculatedDigest) {
        this.preCalculatedDigest = preCalculatedDigest;
    }
}

