/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.DSSDocumentXMLSignatureInput;
import eu.europa.esig.dss.xades.validation.DigestDocumentXMLSignatureInput;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.List;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;

public class DetachedSignatureResolver
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(DetachedSignatureResolver.class);
    private final List<DSSDocument> documents;
    private final DigestAlgorithm digestAlgorithm;

    public DetachedSignatureResolver(List<DSSDocument> documents, DigestAlgorithm digestAlgorithm) {
        this.documents = documents;
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        DSSDocument document = this.getBestCandidate(context);
        if (document instanceof DigestDocument) {
            return new DigestDocumentXMLSignatureInput((DigestDocument)document, this.getDigestAlgorithm(context));
        }
        DSSDocumentXMLSignatureInput xmlSignatureInput = new DSSDocumentXMLSignatureInput(document);
        xmlSignatureInput.setPreCalculatedDigest(this.getPreCalculatedDigest(document, context));
        return xmlSignatureInput;
    }

    private DSSDocument getBestCandidate(ResourceResolverContext context) throws ResourceResolverException {
        if (this.definedFilename(context) && this.isDocumentNamesDefined()) {
            Attr uriAttr = context.attr;
            String uriValue = DSSUtils.decodeURI(uriAttr.getNodeValue());
            Digest referenceDigest = DSSXMLUtils.getDigestAndValue(uriAttr.getOwnerElement());
            DSSDocument bestCandidate = this.getBestCandidateByDigest(referenceDigest, uriValue);
            if (bestCandidate == null) {
                bestCandidate = this.getBestCandidateByName(uriValue);
            }
            if (bestCandidate != null) {
                return bestCandidate;
            }
            Object[] exArgs = new Object[]{"Unable to find document '" + uriValue + "' (detached signature)"};
            throw new ResourceResolverException("generic.EmptyMessage", exArgs, uriValue, context.baseUri);
        }
        if (Utils.collectionSize(this.documents) == 1) {
            return this.documents.get(0);
        }
        Object[] exArgs = new Object[]{"Unable to find document (detached signature)"};
        throw new ResourceResolverException("generic.EmptyMessage", exArgs, null, context.baseUri);
    }

    private DSSDocument getBestCandidateByDigest(Digest referenceDigest, String uriValue) {
        if (referenceDigest == null) {
            return null;
        }
        DSSDocument bestCandidate = null;
        for (DSSDocument dssDocument : this.documents) {
            if (!referenceDigest.equals(this.getDocumentDigest(referenceDigest.getAlgorithm(), dssDocument))) continue;
            if (bestCandidate != null) {
                LOG.warn("Multiple documents match the same reference with URI '{}'!", (Object)uriValue);
                if (!Utils.areStringsEqual(dssDocument.getName(), uriValue)) continue;
            }
            bestCandidate = dssDocument;
        }
        return bestCandidate;
    }

    private DSSDocument getBestCandidateByName(String uriValue) {
        if (uriValue == null) {
            return null;
        }
        DSSDocument bestCandidate = null;
        for (DSSDocument dssDocument : this.documents) {
            if (!uriValue.equals(dssDocument.getName())) continue;
            if (bestCandidate != null) {
                LOG.warn("Multiple documents match the same reference with URI '{}'!", (Object)uriValue);
                break;
            }
            bestCandidate = dssDocument;
        }
        return bestCandidate;
    }

    private Digest getDocumentDigest(DigestAlgorithm referenceDigestAlgorithm, DSSDocument document) {
        try {
            return DSSUtils.getDigest(referenceDigestAlgorithm, document);
        }
        catch (Exception e) {
            String errorMessage = "Unable to get digest for a document with name '{}' : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, document.getName(), e.getMessage(), e);
            } else {
                LOG.warn(errorMessage, (Object)document.getName(), (Object)e.getMessage());
            }
            return new Digest();
        }
    }

    private DigestAlgorithm getDigestAlgorithm(ResourceResolverContext context) {
        DigestAlgorithm referenceDigestAlgorithm = this.getReferenceDigestAlgorithm(context);
        return referenceDigestAlgorithm != null ? referenceDigestAlgorithm : this.digestAlgorithm;
    }

    private DigestAlgorithm getReferenceDigestAlgorithm(ResourceResolverContext context) {
        Digest digestAndValue;
        if (context.attr != null && (digestAndValue = DSSXMLUtils.getDigestAndValue(context.attr.getOwnerElement())) != null) {
            return digestAndValue.getAlgorithm();
        }
        return null;
    }

    private String getPreCalculatedDigest(DSSDocument document, ResourceResolverContext context) {
        DigestAlgorithm referenceDigestAlgorithm;
        if (context.attr != null && !DSSXMLUtils.containsTransforms(context.attr.getOwnerElement()) && (referenceDigestAlgorithm = this.getReferenceDigestAlgorithm(context)) != null) {
            byte[] digestValue = document.getDigestValue(referenceDigestAlgorithm);
            return Utils.toBase64(digestValue);
        }
        return null;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return this.nullURI(context) || this.definedFilename(context);
    }

    private boolean nullURI(ResourceResolverContext context) {
        return context.attr == null;
    }

    private boolean definedFilename(ResourceResolverContext context) {
        Attr uriAttr = context.attr;
        return uriAttr != null && Utils.isStringNotBlank(uriAttr.getNodeValue()) && !DomUtils.startsFromHash(uriAttr.getNodeValue());
    }

    private boolean isDocumentNamesDefined() {
        if (Utils.isCollectionNotEmpty(this.documents)) {
            for (DSSDocument dssDocument : this.documents) {
                if (dssDocument.getName() == null) continue;
                return true;
            }
        }
        return false;
    }
}

