/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformsDescriptionBuilder {
    private static final Map<String, String> presentableTransformationNames = new HashMap<String, String>();
    private final Element transforms;

    public TransformsDescriptionBuilder(Element transforms) {
        this.transforms = transforms;
    }

    public List<String> build() {
        NodeList transformChildNodes;
        ArrayList<String> transformsList = new ArrayList<String>();
        if (this.transforms != null && (transformChildNodes = this.transforms.getChildNodes()) != null && transformChildNodes.getLength() > 0) {
            for (int i = 0; i < transformChildNodes.getLength(); ++i) {
                Node transformation = transformChildNodes.item(i);
                if (1 != transformation.getNodeType()) continue;
                transformsList.add(this.buildTransformationName(transformation));
            }
        }
        return transformsList;
    }

    private String buildTransformationName(Node transformation) {
        String algorithmUri;
        String algorithm = algorithmUri = DomUtils.getValue(transformation, "@Algorithm");
        if (presentableTransformationNames.containsKey(algorithmUri)) {
            algorithm = presentableTransformationNames.get(algorithmUri);
        }
        StringBuilder stringBuilder = new StringBuilder(algorithm);
        if (transformation.hasChildNodes()) {
            NodeList childNodes = transformation.getChildNodes();
            stringBuilder.append(" (");
            boolean hasValues = false;
            for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                Node parameterNode = childNodes.item(ii);
                if (1 != parameterNode.getNodeType()) continue;
                NamedNodeMap attributes = parameterNode.getAttributes();
                for (int jj = 0; jj < attributes.getLength(); ++jj) {
                    Node attribute = attributes.item(jj);
                    String attrName = attribute.getLocalName();
                    String attrValue = attribute.getNodeValue();
                    if (algorithmUri.equals(attrValue)) continue;
                    if (hasValues) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(attrName).append(": ");
                    stringBuilder.append(attrValue);
                    hasValues = true;
                }
                Node parameterValueNode = parameterNode.getFirstChild();
                if (parameterValueNode == null || 3 != parameterValueNode.getNodeType() || !Utils.isStringNotBlank(parameterValueNode.getTextContent())) continue;
                if (hasValues) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(parameterNode.getLocalName()).append(": ");
                stringBuilder.append(parameterValueNode.getTextContent());
                hasValues = true;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    static {
        presentableTransformationNames.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "Enveloped Signature Transform");
        presentableTransformationNames.put("http://www.w3.org/2000/09/xmldsig#base64", "Base64 Decoding");
        presentableTransformationNames.put("http://www.w3.org/2002/06/xmldsig-filter2", "XPath Filter 2.0 Transform");
        presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath filtering");
        presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "XSLT Transform");
        presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "Canonical XML 1.0 with Comments");
        presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11#WithComments", "Canonical XML 1.1 with Comments");
        presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "Exclusive XML Canonicalization 1.0 with Comments");
        presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "Canonical XML 1.0 (omits comments)");
        presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11", "Canonical XML 1.1 (omits comments)");
        presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#", "Exclusive Canonical XML (omits comments)");
    }
}

