/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class RGBColorFunction
extends FunctionBase {
    RGBColorFunction() {
    }

    @Override
    public int getRequiredArgsCount() {
        return 3;
    }

    @Override
    public PercentBase getPercentBase() {
        return new RGBPercentBase();
    }

    @Override
    public Property eval(Property[] args2, PropertyInfo pInfo) throws PropertyException {
        return ColorProperty.getInstance(pInfo.getUserAgent(), "rgb(" + args2[0] + "," + args2[1] + "," + args2[2] + ")");
    }

    private static class RGBPercentBase
    implements PercentBase {
        private RGBPercentBase() {
        }

        @Override
        public int getDimension() {
            return 0;
        }

        @Override
        public double getBaseValue() {
            return 255.0;
        }

        @Override
        public int getBaseLength(PercentBaseContext context) {
            return 0;
        }
    }
}

