/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFDictionary
extends PDFObject {
    private boolean visited;
    protected Map<String, Object> entries = new HashMap<String, Object>();
    protected List<String> order = new ArrayList<String>();

    public PDFDictionary() {
    }

    public PDFDictionary(PDFObject parent) {
        super(parent);
    }

    public void put(String name, Object value) {
        PDFObject pdfObj;
        if (value instanceof PDFObject && !(pdfObj = (PDFObject)value).hasObjectNumber()) {
            pdfObj.setParent(this);
        }
        if (!this.entries.containsKey(name)) {
            this.order.add(name);
        }
        this.entries.put(name, value);
    }

    public void put(String name, int value) {
        if (!this.entries.containsKey(name)) {
            this.order.add(name);
        }
        this.entries.put(name, value);
    }

    public Object get(String name) {
        return this.entries.get(name);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        this.writeDictionary(cout, textBuffer);
        PDFDocument.flushTextBuffer(textBuffer, cout);
        return cout.getCount();
    }

    protected void writeDictionary(OutputStream out, StringBuilder textBuffer) throws IOException {
        textBuffer.append("<<");
        boolean compact = this.order.size() <= 2;
        for (String key : this.order) {
            if (compact) {
                textBuffer.append(' ');
            } else {
                textBuffer.append("\n  ");
            }
            textBuffer.append(PDFName.escapeName(key));
            textBuffer.append(' ');
            Object obj = this.entries.get(key);
            this.formatObject(obj, out, textBuffer);
        }
        if (compact) {
            textBuffer.append(' ');
        } else {
            textBuffer.append('\n');
        }
        textBuffer.append(">>");
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        if (!this.visited) {
            this.visited = true;
            HashMap<String, Object> childrenMap = new HashMap<String, Object>(this.entries);
            childrenMap.remove("Parent");
            PDFDictionary.getChildren(childrenMap.values(), children);
            this.visited = false;
        }
    }

    public static void getChildren(Collection<Object> values2, Set<PDFObject> children) {
        for (Object x : values2) {
            if (x instanceof PDFReference) {
                x = ((PDFReference)x).getObject();
            }
            if (!(x instanceof PDFObject)) continue;
            if (((PDFObject)x).hasObjectNumber()) {
                children.add((PDFObject)x);
            }
            ((PDFObject)x).getChildren(children);
        }
    }

    public Set<String> keySet() {
        return this.entries.keySet();
    }

    public boolean containsKey(String name) {
        return this.entries.containsKey(name);
    }

    public void remove(String name) {
        this.entries.remove(name);
    }
}

