/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import java.util.Date;
import java.util.Objects;

public class ASiCWithCAdESSignatureParameters
extends CAdESSignatureParameters
implements ASiCWithCAdESCommonParameters {
    private static final long serialVersionUID = -830012801924753709L;
    private ASiCParameters asicParams = new ASiCParameters();

    @Override
    public ASiCParameters aSiC() {
        return this.asicParams;
    }

    @Override
    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.CAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only CAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    @Override
    public Date getZipCreationDate() {
        return this.bLevel().getSigningDate();
    }

    @Override
    public String toString() {
        return "ASiCWithCAdESSignatureParameters [asicParams=" + this.asicParams + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ASiCWithCAdESSignatureParameters that = (ASiCWithCAdESSignatureParameters)o;
        return Objects.equals(this.asicParams, that.asicParams);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.asicParams);
        return result;
    }
}

