/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.evidencerecord.ASiCWithCAdESContainerEvidenceRecordBuilder;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESASiCContentBuilder;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESLevelBaselineLTA;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureExtension;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureExtensionHelper;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.timestamp.ASiCWithCAdESTimestampService;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESAnalyzer;
import eu.europa.esig.dss.asic.common.ASiCContainerEvidenceRecordParameters;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.ASiCSignatureExtensionHelper;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEmbeddedEvidenceRecordBuilder;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEvidenceRecordIncorporationParameters;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureBuilder;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCWithCAdESService
extends AbstractASiCSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters, CAdESCounterSignatureParameters, CAdESEvidenceRecordIncorporationParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESService.class);
    private ASiCWithCAdESFilenameFactory asicFilenameFactory = new DefaultASiCWithCAdESFilenameFactory();
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = CAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;

    public ASiCWithCAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with CAdES created");
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = CMSUtils.getDSSResourcesHandlerBuilder(resourcesHandlerBuilder);
    }

    public void setAsicFilenameFactory(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        Objects.requireNonNull(asicFilenameFactory, "ASiCWithCAdESFilenameFactory cannot be null!");
        this.asicFilenameFactory = asicFilenameFactory;
    }

    @Override
    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        return this.getCAdESService().getContentTimestamp(toBeSigned, parameters);
    }

    @Override
    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid(parameters);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        this.assertSignaturePossible(asicContent.getTimestampDocuments(), parameters.aSiC());
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters, dataToSignHelper);
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        return this.getCAdESService().getDataToSign(toBeSigned, cadesParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid(parameters);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSignaturePossible(asicContent.getTimestampDocuments(), asicParameters);
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters, dataToSignHelper);
        boolean addASiCArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), parameters.aSiC().getContainerType());
        if (addASiCArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        if (ASiCContainerType.ASiC_E == asicParameters.getContainerType()) {
            asicContent.getManifestDocuments().add(toBeSigned);
        }
        DSSDocument signature = this.getCAdESService().signDocument(toBeSigned, cadesParameters, signatureValue);
        signature.setName(this.asicFilenameFactory.getSignatureFilename(asicContent));
        ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), signature);
        if (addASiCArchiveManifest) {
            try {
                ASiCWithCAdESLevelBaselineLTA extensionProfile = this.getLTALevelExtensionProfile();
                asicContent = ((ASiCWithCAdESSignatureExtension)extensionProfile).extend(asicContent, parameters);
            }
            finally {
                cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
            }
        }
        DSSDocument asicContainer = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        parameters.reinit();
        return asicContainer;
    }

    @Override
    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, ASiCWithCAdESTimestampParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toTimestampDocuments)) {
            throw new IllegalArgumentException("List of documents to be timestamped cannot be empty!");
        }
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toTimestampDocuments, parameters.aSiC().getContainerType());
        ASiCParameters asicParameters = parameters.aSiC();
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        this.assertTimestampPossible(signatureDocuments, asicParameters);
        List<DSSDocument> signatures = asicContent.getSignatureDocuments();
        List<DSSDocument> timestampDocuments = asicContent.getTimestampDocuments();
        if ((Utils.isCollectionNotEmpty(signatures) || Utils.isCollectionNotEmpty(timestampDocuments)) && this.isLtaExtensionPossible(asicContent)) {
            DSSDocument toTimestampDocument = toTimestampDocuments.get(0);
            ASiCWithCAdESLevelBaselineLTA extensionProfile = this.getLTALevelExtensionProfile();
            asicContent = extensionProfile.extend(asicContent, parameters.getDigestAlgorithm());
            DSSDocument extensionResult = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
            extensionResult.setName(this.getFinalDocumentName(toTimestampDocument, SigningOperation.TIMESTAMP, null, toTimestampDocument.getMimeType()));
            return extensionResult;
        }
        ASiCWithCAdESTimestampService timestampService = new ASiCWithCAdESTimestampService(this.tspSource, this.asicFilenameFactory);
        asicContent = timestampService.timestamp(asicContent, parameters);
        DSSDocument asicContainer = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.TIMESTAMP, null, asicContainer.getMimeType()));
        return asicContainer;
    }

    private boolean isLtaExtensionPossible(ASiCContent asicContent) {
        ASiCContainerWithCAdESAnalyzer validator = new ASiCContainerWithCAdESAnalyzer(asicContent);
        validator.setCertificateVerifier(this.certificateVerifier);
        List<AdvancedSignature> signatures = validator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!Utils.isCollectionEmpty(signature.getSignatureTimestamps())) continue;
            LOG.warn("Extension with an ArchiveManifest is not possible, because a signature with Id '{}' does not have a signature-time-stamp attribute!Add a simple timestamp on signed data.", (Object)signature.getId());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        this.assertExtensionSupported(toExtendDocument);
        ASiCContent asicContent = this.extractCurrentArchive(toExtendDocument);
        this.assertValidSignaturesToExtendFound(asicContent.getSignatureDocuments());
        ASiCContainerType containerType = asicContent.getContainerType();
        if (containerType == null) {
            throw new IllegalInputException("The container type of the provided document is not supported or cannot be extracted!");
        }
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        boolean addASiCEArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), containerType);
        ASiCWithCAdESSignatureExtension extensionProfile = this.getExtensionProfile(parameters.getSignatureLevel(), containerType);
        if (addASiCEArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        try {
            asicContent = extensionProfile.extend(asicContent, parameters);
        }
        finally {
            if (addASiCEArchiveManifest) {
                cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
            }
        }
        DSSDocument extensionResult = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        extensionResult.setName(this.getFinalDocumentName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    private void assertExtensionSupported(DSSDocument toExtendDocument) {
        if (!ASiCUtils.isASiC(toExtendDocument)) {
            throw new IllegalInputException("The provided file is not ASiC document!");
        }
    }

    private void assertValidSignaturesToExtendFound(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No supported signature documents found! Unable to extend the container.");
        }
    }

    @Override
    protected DefaultASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithCAdESContainerExtractor(archive);
    }

    protected CAdESService getCAdESService() {
        CAdESService cadesService = new CAdESService(this.certificateVerifier);
        cadesService.setTspSource(this.tspSource);
        if (CAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER != this.resourcesHandlerBuilder) {
            cadesService.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        }
        return cadesService;
    }

    protected CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters) {
        parameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        parameters.getContext().setDetachedContents(null);
        return parameters;
    }

    protected CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters, GetDataToSignASiCWithCAdESHelper dataToSignHelper) {
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.getContext().setDetachedContents(dataToSignHelper.getDetachedContents());
        cadesParameters.setParallelSignature(Utils.isCollectionNotEmpty(dataToSignHelper.getDetachedContents()));
        return cadesParameters;
    }

    private boolean isAddASiCEArchiveManifest(SignatureLevel signatureLevel, ASiCContainerType containerType) {
        return SignatureLevel.CAdES_BASELINE_LTA == signatureLevel && ASiCContainerType.ASiC_E == containerType;
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument asicContainer, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(asicContainer, "The asicContainer cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        ASiCContent asicContent = this.extractCurrentArchive(asicContainer);
        this.assertAddSignaturePolicyStorePossible(asicContent);
        CAdESService cadesService = this.getCAdESService();
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        for (DSSDocument signature : new ArrayList<DSSDocument>(signatureDocuments)) {
            DSSDocument signatureWithPolicyStore = cadesService.addSignaturePolicyStore(signature, signaturePolicyStore);
            signatureWithPolicyStore.setName(signature.getName());
            ASiCUtils.addOrReplaceDocument(signatureDocuments, signatureWithPolicyStore);
        }
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, null);
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_SIG_POLICY_STORE, asicContainer.getMimeType()));
        return resultArchive;
    }

    @Override
    protected void assertAddSignaturePolicyStorePossible(ASiCContent asicContent) {
        super.assertAddSignaturePolicyStorePossible(asicContent);
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        for (DSSDocument signature : signatureDocuments) {
            if (!ASiCUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), signature.getName())) continue;
            throw new IllegalInputException(String.format("Not possible to add a signature policy store! Reason : a signature with a filename '%s' is covered by another manifest.", signature.getName()));
        }
    }

    @Override
    public ToBeSigned getDataToBeCounterSigned(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid(parameters);
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESSignatureExtensionHelper counterSignatureHelper = new ASiCWithCAdESSignatureExtensionHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CAdESCounterSignatureBuilder counterSignatureBuilder = this.getCAdESCounterSignatureBuilder();
        counterSignatureBuilder.setManifestFile(((ASiCSignatureExtensionHelper)counterSignatureHelper).getManifestFile(signatureDocument.getName()));
        counterSignatureBuilder.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        SignerInformation signerInfoToCounterSign = counterSignatureBuilder.getSignerInformationToBeCounterSigned(signatureDocument, parameters);
        CAdESService cadesService = this.getCAdESService();
        return cadesService.getDataToBeCounterSigned(signerInfoToCounterSign, (CAdESSignatureParameters)parameters);
    }

    @Override
    public DSSDocument counterSignSignature(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESSignatureExtensionHelper counterSignatureHelper = new ASiCWithCAdESSignatureExtensionHelper(asicContainer);
        ASiCContent asicContent = counterSignatureHelper.getAsicContent();
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CMS originalCMS = CMSUtils.parseToCMS(signatureDocument);
        CAdESCounterSignatureBuilder counterSignatureBuilder = this.getCAdESCounterSignatureBuilder();
        counterSignatureBuilder.setManifestFile(((ASiCSignatureExtensionHelper)counterSignatureHelper).getManifestFile(signatureDocument.getName()));
        DSSDocument counterSignedSignature = counterSignatureBuilder.addCounterSignature(originalCMS, parameters, signatureValue);
        counterSignedSignature.setName(signatureDocument.getName());
        ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), counterSignedSignature);
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, parameters.bLevel().getSigningDate());
        resultArchive.setName(this.getFinalDocumentName(asicContainer, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        return resultArchive;
    }

    @Override
    public DSSDocument addSignatureEvidenceRecord(DSSDocument asicContainer, DSSDocument evidenceRecordDocument, CAdESEvidenceRecordIncorporationParameters parameters) {
        Objects.requireNonNull(asicContainer, "The ASiC container cannot be null!");
        Objects.requireNonNull(evidenceRecordDocument, "The evidence record document cannot be null!");
        Objects.requireNonNull(parameters, "Parameters cannot be null!");
        ASiCWithCAdESSignatureExtensionHelper asicContainerHelper = new ASiCWithCAdESSignatureExtensionHelper(asicContainer);
        ASiCContent asicContent = asicContainerHelper.getAsicContent();
        DSSDocument signatureDocument = asicContainerHelper.extractSignatureDocument(parameters.getSignatureId());
        parameters.setDetachedContents(((ASiCSignatureExtensionHelper)asicContainerHelper).getDetachedDocuments(signatureDocument.getName()));
        CAdESEmbeddedEvidenceRecordBuilder builder = new CAdESEmbeddedEvidenceRecordBuilder(this.certificateVerifier);
        builder.setManifestFile(((ASiCSignatureExtensionHelper)asicContainerHelper).getManifestFile(signatureDocument.getName()));
        DSSDocument signatureWithEvidenceRecord = builder.addEvidenceRecord(signatureDocument, evidenceRecordDocument, parameters);
        signatureWithEvidenceRecord.setName(signatureDocument.getName());
        ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), signatureWithEvidenceRecord);
        DSSDocument resultArchive = this.buildASiCContainer(asicContent);
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_EVIDENCE_RECORD, asicContainer.getMimeType()));
        return resultArchive;
    }

    @Override
    public DSSDocument addContainerEvidenceRecord(List<DSSDocument> documents, DSSDocument evidenceRecordDocument, ASiCContainerEvidenceRecordParameters parameters) {
        Objects.requireNonNull(evidenceRecordDocument, "The evidence record document cannot be null!");
        Objects.requireNonNull(parameters, "Parameters cannot be null!");
        Objects.requireNonNull(parameters.getContainerType(), "ASiCContainerType must be defined!");
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalArgumentException("List of documents cannot be empty!");
        }
        ASiCContent asicContent = new ASiCWithCAdESContainerEvidenceRecordBuilder(this.certificateVerifier, this.asicFilenameFactory).build(documents, evidenceRecordDocument, parameters);
        DSSDocument asicContainer = this.buildASiCContainer(asicContent);
        asicContainer.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_EVIDENCE_RECORD, asicContainer.getMimeType()));
        return asicContainer;
    }

    protected ASiCWithCAdESSignatureExtension getExtensionProfile(SignatureLevel signatureLevel, ASiCContainerType containerType) {
        ASiCWithCAdESSignatureExtension extensionProfile;
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case CAdES_BASELINE_T: 
            case CAdES_BASELINE_LT: {
                extensionProfile = new ASiCWithCAdESSignatureExtension(this.certificateVerifier, this.tspSource);
                break;
            }
            case CAdES_BASELINE_LTA: {
                extensionProfile = ASiCContainerType.ASiC_E.equals((Object)containerType) ? new ASiCWithCAdESLevelBaselineLTA(this.certificateVerifier, this.tspSource, this.asicFilenameFactory) : new ASiCWithCAdESSignatureExtension(this.certificateVerifier, this.tspSource);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{signatureLevel}));
            }
        }
        extensionProfile.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return extensionProfile;
    }

    protected ASiCWithCAdESLevelBaselineLTA getLTALevelExtensionProfile() {
        ASiCWithCAdESLevelBaselineLTA extensionProfile = new ASiCWithCAdESLevelBaselineLTA(this.certificateVerifier, this.tspSource, this.asicFilenameFactory);
        extensionProfile.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return extensionProfile;
    }

    protected CAdESCounterSignatureBuilder getCAdESCounterSignatureBuilder() {
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return counterSignatureBuilder;
    }

    @Override
    protected void assertCounterSignatureParametersValid(CAdESCounterSignatureParameters parameters) {
        super.assertCounterSignatureParametersValid(parameters);
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("A counter signature with a level '%s' is not supported! Please, use CAdES-BASELINE-B", new Object[]{parameters.getSignatureLevel()}));
        }
    }

    private void assertSignaturePossible(List<DSSDocument> timestampDocuments, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS(asicParameters) && Utils.isCollectionNotEmpty(timestampDocuments)) {
            throw new IllegalInputException("Unable to sign an ASiC-S with CAdES container containing time assertion files!");
        }
    }

    private void assertTimestampPossible(List<DSSDocument> signatureDocuments, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS(asicParameters) && Utils.isCollectionNotEmpty(signatureDocuments)) {
            throw new IllegalInputException("Unable to timestamp an ASiC-S with CAdES container containing signature files! Use extendDocument(...) method for signature extension.");
        }
    }
}

