/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFormatDetector;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.cades.validation.timestamp.ASiCWithCAdESTimestampAnalyzer;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestValidator;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerAnalyzer;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.timestamp.TimestampAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.timestamp.TimestampAnalyzerComparator;
import eu.europa.esig.dss.spi.validation.timestamp.DetachedTimestampSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESAnalyzer
extends AbstractASiCContainerAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESAnalyzer.class);

    ASiCContainerWithCAdESAnalyzer() {
    }

    public ASiCContainerWithCAdESAnalyzer(DSSDocument asicContainer) {
        super(asicContainer);
    }

    public ASiCContainerWithCAdESAnalyzer(ASiCContent asicContent) {
        super(asicContent);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new ASiCWithCAdESFormatDetector().isSupportedASiC(dssDocument);
    }

    @Override
    public boolean isSupported(ASiCContent asicContent) {
        return new ASiCWithCAdESFormatDetector().isSupportedASiC(asicContent);
    }

    @Override
    protected DefaultASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    @Override
    protected List<DocumentAnalyzer> getSignatureAnalyzers() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                DSSDocument signatureManifest;
                CMSDocumentAnalyzer cadesValidator = new CMSDocumentAnalyzer(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                DSSDocument signedDocument = ASiCWithCAdESUtils.getSignedDocument(this.asicContent, signature.getName());
                if (signedDocument != null) {
                    cadesValidator.setDetachedContents(Collections.singletonList(signedDocument));
                }
                if ((signatureManifest = ASiCManifestParser.getLinkedManifest(this.getAllManifestDocuments(), signature.getName())) != null) {
                    ManifestFile manifestFile = this.getValidatedManifestFile(signatureManifest);
                    cadesValidator.setManifestFile(manifestFile);
                }
                this.signatureValidators.add(cadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<TimestampAnalyzer> getTimestampAnalyzers() {
        if (this.timestampAnalyzers == null) {
            this.timestampAnalyzers = new ArrayList();
            for (DSSDocument timestamp : this.getTimestampDocuments()) {
                ASiCWithCAdESTimestampAnalyzer timestampValidator = this.getTimestampValidator(timestamp);
                if (timestampValidator == null) continue;
                this.timestampAnalyzers.add(timestampValidator);
            }
            this.timestampAnalyzers.sort(new TimestampAnalyzerComparator());
        }
        return this.timestampAnalyzers;
    }

    private ASiCWithCAdESTimestampAnalyzer getTimestampValidator(DSSDocument timestampDocument) {
        DSSDocument timestampedDocument;
        ManifestFile manifestFile = null;
        ArchiveTimestampType archiveTimestampType = null;
        DSSDocument archiveManifest = ASiCManifestParser.getLinkedManifest(this.getAllManifestDocuments(), timestampDocument.getName());
        if (archiveManifest != null) {
            timestampedDocument = archiveManifest;
            manifestFile = this.getValidatedManifestFile(archiveManifest);
            if (manifestFile != null) {
                archiveTimestampType = this.isArchiveTimeStamp(manifestFile) ? ArchiveTimestampType.CAdES_DETACHED : null;
            } else {
                LOG.warn("A linked manifest is not found for a timestamp with name [{}]!", (Object)archiveManifest.getName());
            }
        } else {
            List<DSSDocument> rootLevelSignedDocuments = ASiCUtils.getRootLevelSignedDocuments(this.asicContent);
            if (Utils.collectionSize(rootLevelSignedDocuments) == 1) {
                timestampedDocument = rootLevelSignedDocuments.get(0);
            } else {
                LOG.warn("Timestamp {} is skipped (no linked archive manifest found / unique file)", (Object)timestampDocument.getName());
                return null;
            }
        }
        ASiCWithCAdESTimestampAnalyzer timestampValidator = new ASiCWithCAdESTimestampAnalyzer(timestampDocument, TimestampType.CONTAINER_TIMESTAMP);
        timestampValidator.setTimestampedData(timestampedDocument);
        timestampValidator.setManifestFile(manifestFile);
        timestampValidator.setArchiveTimestampType(archiveTimestampType);
        timestampValidator.setOriginalDocuments(this.getAllDocuments());
        timestampValidator.setArchiveDocuments(this.getArchiveDocuments());
        timestampValidator.setDetachedEvidenceRecords(this.getDetachedEvidenceRecords());
        timestampValidator.setCertificateVerifier(this.certificateVerifier);
        return timestampValidator;
    }

    @Override
    protected List<TimestampToken> buildDetachedTimestamps() {
        DetachedTimestampSource detachedTimestampSource = new DetachedTimestampSource();
        for (TimestampAnalyzer timestampAnalyzer : this.getTimestampAnalyzers()) {
            detachedTimestampSource.addExternalTimestamp(timestampAnalyzer.getTimestamp());
        }
        return detachedTimestampSource.getDetachedTimestamps();
    }

    @Override
    public List<DSSDocument> getArchiveDocuments() {
        List<DSSDocument> archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty(this.getManifestDocuments())) {
            for (DSSDocument document : this.getAllDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    @Override
    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        List<TimestampAnalyzer> currentTimestampAnalyzers = this.getTimestampAnalyzers();
        for (TimestampAnalyzer tstAnalyzer : currentTimestampAnalyzers) {
            TimestampToken timestamp = this.getExternalTimestamp(tstAnalyzer, allSignatures);
            if (timestamp == null) continue;
            externalTimestamps.add(timestamp);
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(TimestampAnalyzer tstAnalyzer, List<AdvancedSignature> allSignatures) {
        if (tstAnalyzer instanceof ASiCWithCAdESTimestampAnalyzer) {
            ManifestFile coveredManifest;
            ASiCWithCAdESTimestampAnalyzer timestampValidator = (ASiCWithCAdESTimestampAnalyzer)tstAnalyzer;
            TimestampToken timestamp = timestampValidator.getTimestamp();
            if (timestamp.getTimeStampType().isContainerTimestamp() && (coveredManifest = timestampValidator.getCoveredManifest()) != null) {
                for (ManifestEntry entry : coveredManifest.getEntries()) {
                    CAdESSignature cadesSignature = this.getCAdESSignatureFromFileName(allSignatures, entry.getUri());
                    if (cadesSignature == null) continue;
                    cadesSignature.addExternalTimestamp(timestamp);
                }
            }
            return timestamp;
        }
        return null;
    }

    private CAdESSignature getCAdESSignatureFromFileName(List<AdvancedSignature> signatures, String fileName) {
        for (AdvancedSignature advancedSignature : signatures) {
            if (!Utils.areStringsEqual(fileName, advancedSignature.getFilename()) || advancedSignature.isCounterSignature()) continue;
            return (CAdESSignature)advancedSignature;
        }
        return null;
    }

    private boolean isArchiveTimeStamp(ManifestFile manifestFile) {
        return ASiCUtils.coversSignature(manifestFile);
    }

    @Override
    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List<DSSDocument> manifestDocuments = this.getManifestDocuments();
        for (DSSDocument dSSDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile(dSSDocument);
            if (manifestFile == null) continue;
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List<DSSDocument> archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.ARCHIVE_MANIFEST);
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List<DSSDocument> list = this.getEvidenceRecordManifestDocuments();
        for (DSSDocument manifestDocument : list) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.EVIDENCE_RECORD);
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        if (advancedSignature.isCounterSignature()) {
            CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
            return Collections.singletonList(cadesSignature.getOriginalDocument());
        }
        List<DSSDocument> retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest(this.getManifestDocuments(), advancedSignature.getFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCManifestParser.getManifestFile(linkedManifest);
        if (manifestFile == null) {
            return Collections.emptyList();
        }
        return this.getManifestedDocuments(manifestFile);
    }

    private List<DSSDocument> getManifestedDocuments(ManifestFile manifestFile) {
        List<ManifestEntry> entries = manifestFile.getEntries();
        List<DSSDocument> signedDocuments = this.getAllDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual(entry.getUri(), signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }
}

