/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.spi.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESTimestampScopeFinder
extends DetachedTimestampScopeFinder {
    private List<DSSDocument> containerDocuments;
    private List<DSSDocument> archiveDocuments;

    public void setContainerDocuments(List<DSSDocument> containerDocuments) {
        this.containerDocuments = containerDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    @Override
    public List<SignatureScope> findTimestampScope(TimestampToken timestampToken) {
        if (timestampToken.isMessageImprintDataIntact()) {
            if (timestampToken.getManifestFile() != null) {
                return this.getTimestampSignatureScopeForManifest(timestampToken.getManifestFile());
            }
            return this.getTimestampSignatureScopeForDocument(this.timestampedData);
        }
        return Collections.emptyList();
    }

    private List<SignatureScope> getTimestampSignatureScopeForManifest(ManifestFile manifestFile) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add(new ManifestSignatureScope(manifestFile));
        if (Utils.isCollectionNotEmpty(this.containerDocuments)) {
            List<DSSDocument> rootLevelDocuments = ASiCUtils.getRootLevelDocuments(this.containerDocuments);
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                result.addAll(this.getTimestampSignatureScopeForManifestEntry(manifestEntry, rootLevelDocuments));
            }
        }
        return result;
    }

    private List<SignatureScope> getTimestampSignatureScopeForManifestEntry(ManifestEntry manifestEntry, List<DSSDocument> rootLevelDocuments) {
        if (manifestEntry.isIntact()) {
            for (DSSDocument document : this.containerDocuments) {
                if (!Utils.areStringsEqual(manifestEntry.getUri(), document.getName())) continue;
                if (Utils.collectionSize(rootLevelDocuments) == 1 && this.isASiCSContainer(document)) {
                    return this.getTimestampSignatureScopeForZipPackage(document);
                }
                return super.getTimestampSignatureScopeForDocument(document);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected List<SignatureScope> getTimestampSignatureScopeForDocument(DSSDocument document) {
        if (this.isASiCSContainer(document)) {
            return this.getTimestampSignatureScopeForZipPackage(document);
        }
        return super.getTimestampSignatureScopeForDocument(document);
    }

    private List<SignatureScope> getTimestampSignatureScopeForZipPackage(DSSDocument document) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add(new ContainerSignatureScope(document));
        if (Utils.isCollectionNotEmpty(this.archiveDocuments)) {
            for (DSSDocument archivedDocument : this.archiveDocuments) {
                result.add(new ContainerContentSignatureScope(archivedDocument));
            }
        }
        return result;
    }

    private boolean isASiCSContainer(DSSDocument document) {
        return document.getName() != null && !document.getName().contains("/") && ASiCUtils.isZip(document);
    }
}

