/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.extract;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.List;

public class ASiCWithXAdESContainerExtractor
extends DefaultASiCContainerExtractor {
    private static final String METAINF_MANIFEST_FILENAME = "META-INF/manifest.xml";

    public ASiCWithXAdESContainerExtractor(DSSDocument archive) {
        super(archive);
    }

    @Override
    public boolean isSupportedContainerFormat() {
        List<String> filenames = ZipUtils.getInstance().extractEntryNames(this.asicContainer);
        return ASiCUtils.isAsicFileContent(filenames) || ASiCUtils.areFilesContainMimetype(filenames) && ASiCUtils.isContainerOpenDocument(this.asicContainer);
    }

    @Override
    protected boolean isAllowedManifest(String entryName) {
        return entryName.equals(METAINF_MANIFEST_FILENAME);
    }

    @Override
    protected boolean isAllowedArchiveManifest(String entryName) {
        return false;
    }

    @Override
    protected boolean isAllowedEvidenceRecordManifest(String entryName) {
        return ASiCUtils.isEvidenceRecordManifest(entryName);
    }

    @Override
    protected boolean isAllowedSignature(String entryName) {
        return ASiCUtils.isXAdES(entryName);
    }

    @Override
    protected boolean isAllowedTimestamp(String entryName) {
        return false;
    }

    @Override
    protected boolean isAllowedEvidenceRecord(String entryName) {
        return "META-INF/evidencerecord.ers".equals(entryName) || "META-INF/evidencerecord.xml".equals(entryName);
    }
}

