/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.merge;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.xades.merge.AbstractASiCWithXAdESContainerMerger;
import eu.europa.esig.dss.asic.xades.signature.asice.ASiCEWithXAdESManifestBuilder;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.xml.security.signature.Reference;

public class ASiCEWithXAdESContainerMerger
extends AbstractASiCWithXAdESContainerMerger {
    ASiCEWithXAdESContainerMerger() {
    }

    public ASiCEWithXAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCEWithXAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && (!ASiCUtils.isASiCSContainer(container) || this.doesNotContainSignatures(container) && this.doesNotContainEvidenceRecords(container));
    }

    private boolean doesNotContainSignatures(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainSignatures(entryNames);
    }

    private boolean doesNotContainEvidenceRecords(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainEvidenceRecords(entryNames);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && (!ASiCUtils.isASiCSContainer(asicContent) || this.doesNotContainSignatures(asicContent) && this.doesNotContainEvidenceRecords(asicContent));
    }

    private boolean doesNotContainSignatures(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getSignatureDocuments());
    }

    private boolean doesNotContainEvidenceRecords(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getEvidenceRecordDocuments());
    }

    @Override
    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_E;
    }

    @Override
    protected void ensureContainerContentAllowMerge() {
        if (Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty(asicContent.getSignatureDocuments()) && Utils.isCollectionEmpty(asicContent.getEvidenceRecordDocuments()))) {
            return;
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. One of the containers contains a detached timestamp!");
        }
        Arrays.stream(this.asicContents).forEach(asicContent -> this.assertEvidenceRecordDocumentNameValid(asicContent.getEvidenceRecordDocuments()));
    }

    private void assertEvidenceRecordDocumentNameValid(List<DSSDocument> evidenceRecordDocuments) {
        if (Utils.isCollectionNotEmpty(evidenceRecordDocuments)) {
            String evidenceRecordDocumentName = null;
            for (DSSDocument evidenceRecordDocument : evidenceRecordDocuments) {
                if (!"META-INF/evidencerecord.xml".equals(evidenceRecordDocument.getName()) && !"META-INF/evidencerecord.ers".equals(evidenceRecordDocument.getName())) {
                    throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. The evidence record document in one of the containers has invalid naming!");
                }
                if (evidenceRecordDocumentName == null) {
                    evidenceRecordDocumentName = evidenceRecordDocument.getName();
                    continue;
                }
                if (evidenceRecordDocumentName.equals(evidenceRecordDocument.getName())) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. The evidence record documents have conflicting names within containers!");
            }
        }
    }

    @Override
    protected void ensureSignaturesAllowMerge() {
        List<String> evidenceRecordManifestDocumentNames;
        List<String> conflictingEvidenceRecordManifestNames;
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getEvidenceRecordDocuments())).count() <= 1L) {
            return;
        }
        List<String> coveredDocumentNames = this.getCoveredDocumentNames();
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> this.doCoverManifest(coveredDocumentNames)) && !this.sameSignedDocuments()) {
            throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. manifest.xml is signed or covered and the signer data does not match between containers!");
        }
        List<String> signatureNames = this.getAllSignatureDocumentNames();
        List<String> conflictingSignatureDocumentNames = this.getConflictingDocumentNames(signatureNames);
        if (Utils.isCollectionNotEmpty(conflictingSignatureDocumentNames)) {
            for (String signatureDocumentName : conflictingSignatureDocumentNames) {
                if (!coveredDocumentNames.contains(signatureDocumentName) || this.isSameDocumentContent(signatureDocumentName)) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. A signature is covered by another document, while having same signature names in both containers!");
            }
            this.ensureSignatureNamesDiffer();
        }
        if (Utils.isCollectionNotEmpty(conflictingEvidenceRecordManifestNames = this.getConflictingDocumentNames(evidenceRecordManifestDocumentNames = this.getAllEvidenceRecordManifestDocumentNames()))) {
            for (String evidenceRecordManifestName : conflictingEvidenceRecordManifestNames) {
                if (!coveredDocumentNames.contains(evidenceRecordManifestName) || this.isSameDocumentContent(evidenceRecordManifestName)) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. An evidence record manifest is covered by another document, while having same signature names in both containers!");
            }
            this.ensureEvidenceRecordManifestNamesDiffer();
        }
        DSSDocument newManifest = this.createNewManifest();
        for (ASiCContent asicContent2 : this.asicContents) {
            asicContent2.setManifestDocuments(Collections.singletonList(newManifest));
        }
    }

    private boolean isSameDocumentContent(String documentName) {
        byte[] digestValue = null;
        for (ASiCContent asicContent : this.asicContents) {
            DSSDocument document = DSSUtils.getDocumentWithName(asicContent.getAllDocuments(), documentName);
            byte[] currentDocumentDigestValue = document.getDigestValue(DEFAULT_DIGEST_ALGORITHM);
            if (digestValue == null) {
                digestValue = currentDocumentDigestValue;
                continue;
            }
            if (Arrays.equals(digestValue, currentDocumentDigestValue)) continue;
            return false;
        }
        return true;
    }

    private List<String> getCoveredDocumentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ASiCContent asicContent : this.asicContents) {
            for (DSSDocument signatureDocument : asicContent.getSignatureDocuments()) {
                XMLDocumentAnalyzer documentValidator = new XMLDocumentAnalyzer(signatureDocument);
                for (AdvancedSignature signature : documentValidator.getSignatures()) {
                    result.addAll(this.getCoveredDocumentNames((XAdESSignature)signature));
                }
            }
            for (DSSDocument manifestDocument : asicContent.getEvidenceRecordManifestDocuments()) {
                ManifestFile manifestFile = ASiCManifestParser.getManifestFile(manifestDocument);
                if (manifestFile == null) continue;
                for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                    result.add(manifestEntry.getUri());
                }
            }
        }
        return result;
    }

    private List<String> getCoveredDocumentNames(XAdESSignature signature) {
        ArrayList<String> result = new ArrayList<String>();
        for (Reference reference : signature.getReferences()) {
            String referenceURI = DSSXMLUtils.getReferenceURI(reference);
            if (DomUtils.startsFromHash(referenceURI) || DomUtils.isXPointerQuery(referenceURI)) continue;
            result.add(referenceURI);
        }
        return result;
    }

    private boolean doCoverManifest(List<String> documentNames) {
        return documentNames.contains("META-INF/manifest.xml");
    }

    private boolean sameSignedDocuments() {
        HashSet<String> signedDocumentNames = null;
        for (ASiCContent asicContent : this.asicContents) {
            HashSet<String> currentSignedDocumentNames = new HashSet<String>(DSSUtils.getDocumentNames(asicContent.getSignedDocuments()));
            if (signedDocumentNames == null) {
                signedDocumentNames = currentSignedDocumentNames;
                continue;
            }
            if (signedDocumentNames.equals(currentSignedDocumentNames)) continue;
            return false;
        }
        return true;
    }

    private List<String> getAllSignatureDocumentNames() {
        ArrayList<String> signatureDocumentNames = new ArrayList<String>();
        for (ASiCContent asicContent : this.asicContents) {
            signatureDocumentNames.addAll(DSSUtils.getDocumentNames(asicContent.getSignatureDocuments()));
        }
        return signatureDocumentNames;
    }

    private List<String> getAllEvidenceRecordManifestDocumentNames() {
        ArrayList<String> erManifestDocumentNames = new ArrayList<String>();
        for (ASiCContent asicContent : this.asicContents) {
            erManifestDocumentNames.addAll(DSSUtils.getDocumentNames(asicContent.getEvidenceRecordManifestDocuments()));
        }
        return erManifestDocumentNames;
    }

    private List<String> getConflictingDocumentNames(List<String> documentNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String signatureDocumentName : documentNames) {
            if (Collections.frequency(documentNames, signatureDocumentName) <= 1) continue;
            result.add(signatureDocumentName);
        }
        return result;
    }

    private DSSDocument createNewManifest() {
        ArrayList<ManifestEntry> manifestEntries = new ArrayList<ManifestEntry>();
        ArrayList<String> addedFileNames = new ArrayList<String>();
        ASiCContent mergedContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            List<DSSDocument> manifestDocuments = asicContent.getManifestDocuments();
            mergedContent.getManifestDocuments().addAll(manifestDocuments);
            for (ManifestEntry entry : this.getManifestFileEntries(manifestDocuments)) {
                if (addedFileNames.contains(entry.getUri())) continue;
                manifestEntries.add(entry);
                addedFileNames.add(entry.getUri());
            }
            List<DSSDocument> signedDocuments = asicContent.getSignedDocuments();
            for (ManifestEntry entry : ASiCUtils.toSimpleManifestEntries(signedDocuments)) {
                if (addedFileNames.contains(entry.getUri())) continue;
                manifestEntries.add(entry);
                addedFileNames.add(entry.getUri());
            }
        }
        return this.createNewManifestXml(manifestEntries, mergedContent);
    }

    private List<ManifestEntry> getManifestFileEntries(List<DSSDocument> manifestDocuments) {
        if (Utils.isCollectionEmpty(manifestDocuments)) {
            return Collections.emptyList();
        }
        if (Utils.collectionSize(manifestDocuments) > 1) {
            throw new IllegalInputException("One of the containers contain multiple manifest files!");
        }
        DSSDocument manifestDocument = manifestDocuments.get(0);
        if (!"META-INF/manifest.xml".equals(manifestDocument.getName())) {
            throw new IllegalInputException(String.format("A manifest file shall have a name '%s'.", "META-INF/manifest.xml"));
        }
        ASiCEWithXAdESManifestParser parser = new ASiCEWithXAdESManifestParser(manifestDocument);
        ManifestFile manifest = parser.getManifest();
        return manifest.getEntries();
    }

    private DSSDocument createNewManifestXml(List<ManifestEntry> manifestEntries, ASiCContent asicContent) {
        return new ASiCEWithXAdESManifestBuilder().setEntries(manifestEntries).setManifestFilename(this.asicFilenameFactory.getManifestFilename(asicContent)).build();
    }

    private void ensureSignatureNamesDiffer() {
        HashSet<String> usedSignatureNames = new HashSet<String>();
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getSignatureDocuments().addAll(asicContent.getSignatureDocuments());
        }
        for (ASiCContent asicContent : this.asicContents) {
            List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
            for (DSSDocument signatureDocument : signatureDocuments) {
                if (usedSignatureNames.contains(signatureDocument.getName())) {
                    String newSignatureName = this.asicFilenameFactory.getSignatureFilename(mergedASiCContent);
                    signatureDocument.setName(newSignatureName);
                }
                usedSignatureNames.add(signatureDocument.getName());
            }
        }
    }

    private void ensureEvidenceRecordManifestNamesDiffer() {
        HashSet<String> usedNames = new HashSet<String>();
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getEvidenceRecordManifestDocuments().addAll(asicContent.getEvidenceRecordManifestDocuments());
        }
        for (ASiCContent asicContent : this.asicContents) {
            List<DSSDocument> evidenceRecordManifestDocuments = asicContent.getEvidenceRecordManifestDocuments();
            for (DSSDocument evidenceRecordManifest : evidenceRecordManifestDocuments) {
                if (usedNames.contains(evidenceRecordManifest.getName())) {
                    String newSignatureName = this.asicFilenameFactory.getEvidenceRecordManifestFilename(mergedASiCContent);
                    evidenceRecordManifest.setName(newSignatureName);
                }
                usedNames.add(evidenceRecordManifest.getName());
            }
        }
    }
}

