/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.TimeStampTokenProductionComparator;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CMSBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineLT
extends CAdESLevelBaselineT {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineLT.class);

    public CAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMS extendCMSSignatures(CMS cms, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        CMSDocumentAnalyzer documentAnalyzer = this.getDocumentValidator(cms = super.extendCMSSignatures(cms, parameters, signatureIdsToExtend), parameters);
        List<AdvancedSignature> signatures = documentAnalyzer.getSignatures();
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures, signatureIdsToExtend);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return cms;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(parameters);
        if (SignatureLevel.CAdES_BASELINE_LT.equals((Object)parameters.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = documentAnalyzer.getValidationData(signaturesToExtend);
        if (this.includesATSv2(cms)) {
            CMSUtils.assertATSv2AugmentationSupported();
            ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
            for (AdvancedSignature signature : signatures) {
                SignerInformation signerInformation;
                CAdESSignature cadesSignature = (CAdESSignature)signature;
                SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
                if (signaturesToExtend.contains(cadesSignature)) {
                    ValidationData validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion(cadesSignature);
                    newSignerInformation = this.extendSignerInformation(signerInformation, validationData);
                }
                newSignerInformationList.add(newSignerInformation);
            }
            cms = this.replaceSigners(cms, newSignerInformationList);
        } else {
            ValidationData allValidationData = validationDataContainer.getAllValidationData();
            for (AdvancedSignature signature : signaturesToExtend) {
                allValidationData.excludeCertificateTokens(signature.getCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens(signature.getCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens(signature.getOCSPSource().getAllRevocationBinaries());
            }
            cms = this.extendWithValidationData(cms, allValidationData);
        }
        return cms;
    }

    private SignerInformation extendSignerInformation(SignerInformation signerInformation, ValidationData validationData) {
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        unsignedAttributes = this.addValidationData(unsignedAttributes, validationData);
        return CMSUtils.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
    }

    private AttributeTable addValidationData(AttributeTable unsignedAttributes, ValidationData validationData) {
        TimeStampToken timestampTokenToExtend = this.getLastArchiveTimestamp(unsignedAttributes);
        if (timestampTokenToExtend != null) {
            CMS timestampCMS = CMSUtils.toCMS(timestampTokenToExtend);
            CMS extendedTimestampCMS = this.extendWithValidationData(timestampCMS, validationData);
            unsignedAttributes = this.replaceTimeStampAttribute(unsignedAttributes, timestampCMS, extendedTimestampCMS);
        }
        return unsignedAttributes;
    }

    private TimeStampToken getLastArchiveTimestamp(AttributeTable unsignedAttributes) {
        TimeStampToken lastTimeStampToken = null;
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (TimeStampToken timeStampToken : CAdESUtils.findArchiveTimeStampTokens(unsignedAttributes)) {
            if (lastTimeStampToken != null && !comparator.after(timeStampToken, lastTimeStampToken)) continue;
            lastTimeStampToken = timeStampToken;
        }
        return lastTimeStampToken;
    }

    private AttributeTable replaceTimeStampAttribute(AttributeTable attributeTable, CMS attributeToReplace, CMS attributeToAdd) {
        Attribute[] attributes;
        ASN1EncodableVector newAsn1EncodableVector = new ASN1EncodableVector();
        Attribute[] attributeArray = attributes = attributeTable.toASN1Structure().getAttributes();
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            Attribute newAttribute = attribute = attributeArray[i];
            if (CAdESUtils.isArchiveTimeStampToken(attribute)) {
                try {
                    byte[] attributeValue = CAdESUtils.getEncodedValue(attribute);
                    if (Arrays.equals(attributeToReplace.getDEREncoded(), attributeValue)) {
                        Object asn1Primitive = DSSASN1Utils.toASN1Primitive(attributeToAdd.getDEREncoded());
                        newAttribute = new Attribute(attribute.getAttrType(), new DERSet((ASN1Encodable)asn1Primitive));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to build a CMS object from an unsigned attribute. Reason : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            newAsn1EncodableVector.add(newAttribute);
        }
        return new AttributeTable(newAsn1EncodableVector);
    }

    private CMS extendWithValidationData(CMS cms, ValidationData validationDataForInclusion) {
        CMSBuilder cmsBuilder = new CMSBuilder().setOriginalCMS(cms);
        return cmsBuilder.extendCMSSignedData(validationDataForInclusion.getCertificateTokens(), validationDataForInclusion.getCrlTokens(), validationDataForInclusion.getOcspTokens());
    }

    protected boolean includesATSv2(CMS cms) {
        for (SignerInformation signerInformation : cms.getSignerInfos()) {
            if (!CAdESUtils.containsATSTv2(signerInformation)) continue;
            return true;
        }
        return false;
    }

    protected List<AdvancedSignature> getExtendToLTLevelSignatures(List<AdvancedSignature> signatures, List<String> signatureIdsToExtend) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!signatureIdsToExtend.contains(signature.getId())) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }
}

