/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.enumerations.ArchiveTimestampHashIndexVersion;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.ArchiveTimestampHashIndexStatus;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CadesLevelBaselineLTATimestampExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CadesLevelBaselineLTATimestampExtractor.class);
    private final CAdESSignature signature;

    public CadesLevelBaselineLTATimestampExtractor(CAdESSignature cadesSignature) {
        Objects.requireNonNull(cadesSignature, "CAdESSignature cannot be null!");
        this.signature = cadesSignature;
    }

    public Attribute getAtsHashIndex(SignerInformation signerInformation, DigestAlgorithm hashIndexDigestAlgorithm, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        AlgorithmIdentifier algorithmIdentifier = this.getHashIndexDigestAlgorithmIdentifier(hashIndexDigestAlgorithm);
        ASN1Sequence certificatesHashIndex = this.getCertificatesHashIndex(hashIndexDigestAlgorithm);
        ASN1Sequence crLsHashIndex = this.getCRLsHashIndex(hashIndexDigestAlgorithm);
        ASN1Sequence unsignedAttributesHashIndex = this.getUnsignedAttributesHashIndex(signerInformation, atsHashIndexVersionIdentifier, hashIndexDigestAlgorithm);
        return this.getComposedAtsHashIndex(algorithmIdentifier, certificatesHashIndex, crLsHashIndex, unsignedAttributesHashIndex, atsHashIndexVersionIdentifier);
    }

    public Attribute getVerifiedAtsHashIndex(SignerInformation signerInformation, TimestampToken timestampToken) {
        ASN1ObjectIdentifier atsHashIndexVersionIdentifier;
        AttributeTable unsignedAttributes = timestampToken.getUnsignedAttributes();
        ASN1Sequence atsHashIndex = CAdESUtils.getAtsHashIndexByVersion(unsignedAttributes, atsHashIndexVersionIdentifier = CAdESUtils.getAtsHashIndexVersionIdentifier(unsignedAttributes));
        if (atsHashIndex == null) {
            LOG.warn("A valid atsHashIndex [oid: {}] has not been found for a timestamp with id {}", (Object)atsHashIndexVersionIdentifier, (Object)timestampToken.getDSSIdAsString());
        }
        ArchiveTimestampHashIndexStatus atsHashIndexStatus = this.buildArchiveTimestampHashIndexStatus(atsHashIndexVersionIdentifier);
        AlgorithmIdentifier derObjectAlgorithmIdentifier = this.getAlgorithmIdentifier(atsHashIndex);
        DigestAlgorithm hashIndexDigestAlgorithm = this.getHashIndexDigestAlgorithm(derObjectAlgorithmIdentifier);
        ASN1Sequence certificatesHashIndex = this.getVerifiedCertificatesHashIndex(atsHashIndex, hashIndexDigestAlgorithm, atsHashIndexStatus);
        ASN1Sequence crLsHashIndex = this.getVerifiedCRLsHashIndex(atsHashIndex, hashIndexDigestAlgorithm, atsHashIndexStatus);
        ASN1Sequence verifiedAttributesHashIndex = this.getVerifiedUnsignedAttributesHashIndex(signerInformation, atsHashIndex, atsHashIndexVersionIdentifier, hashIndexDigestAlgorithm, atsHashIndexStatus);
        timestampToken.setAtsHashIndexStatus(atsHashIndexStatus);
        return this.getComposedAtsHashIndex(derObjectAlgorithmIdentifier, certificatesHashIndex, crLsHashIndex, verifiedAttributesHashIndex, atsHashIndexVersionIdentifier);
    }

    private ArchiveTimestampHashIndexStatus buildArchiveTimestampHashIndexStatus(ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ArchiveTimestampHashIndexStatus status = new ArchiveTimestampHashIndexStatus();
        ArchiveTimestampHashIndexVersion version = null;
        if (atsHashIndexVersionIdentifier != null) {
            version = ArchiveTimestampHashIndexVersion.forOid(atsHashIndexVersionIdentifier.getId());
        }
        if (version != null) {
            status.setVersion(version);
        } else {
            status.addErrorMessage("The ats-hash-index was not found or not supported.");
        }
        return status;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        return algorithmIdentifier != null ? DigestAlgorithm.forOID(algorithmIdentifier.getAlgorithm().getId()) : CAdESUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private Attribute getComposedAtsHashIndex(AlgorithmIdentifier algorithmIdentifiers, ASN1Sequence certificatesHashIndex, ASN1Sequence crLsHashIndex, ASN1Sequence unsignedAttributesHashIndex, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (algorithmIdentifiers != null) {
            vector.add(algorithmIdentifiers);
        } else if (OID.id_aa_ATSHashIndexV2.equals(atsHashIndexVersionIdentifier) || OID.id_aa_ATSHashIndexV3.equals(atsHashIndexVersionIdentifier)) {
            AlgorithmIdentifier sha256AlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(DigestAlgorithm.SHA256.getOid()));
            vector.add(sha256AlgorithmIdentifier);
        }
        if (certificatesHashIndex != null) {
            vector.add(certificatesHashIndex);
        }
        if (crLsHashIndex != null) {
            vector.add(crLsHashIndex);
        }
        if (unsignedAttributesHashIndex != null) {
            vector.add(unsignedAttributesHashIndex);
        }
        DERSequence derSequence = new DERSequence(vector);
        return new Attribute(atsHashIndexVersionIdentifier, new DERSet(derSequence));
    }

    private ASN1Sequence getCertificatesHashIndex(DigestAlgorithm hashIndexDigestAlgorithm) {
        ASN1EncodableVector certificatesHashIndexVector = new ASN1EncodableVector();
        List<CertificateToken> signedDataCertificates = this.signature.getCertificateSource().getSignedDataCertificates();
        for (CertificateToken certificateToken : signedDataCertificates) {
            byte[] digest = certificateToken.getDigest(hashIndexDigestAlgorithm);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding to CertificatesHashIndex DSS-Identifier: {} with hash {}", (Object)certificateToken.getDSSId(), (Object)Utils.toHex(digest));
            }
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            certificatesHashIndexVector.add(derOctetStringDigest);
        }
        return new DERSequence(certificatesHashIndexVector);
    }

    private ASN1Sequence getVerifiedCertificatesHashIndex(ASN1Sequence timestampHashIndex, DigestAlgorithm hashIndexDigestAlgorithm, ArchiveTimestampHashIndexStatus atsHashIndexStatus) {
        ASN1Sequence certHashes = CAdESUtils.getCertificatesHashIndex(timestampHashIndex);
        List<DEROctetString> certHashesList = DSSASN1Utils.getDEROctetStrings(certHashes);
        List<CertificateToken> signedDataCertificates = this.signature.getCertificateSource().getSignedDataCertificates();
        for (CertificateToken certificateToken : signedDataCertificates) {
            byte[] digest = certificateToken.getDigest(hashIndexDigestAlgorithm);
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            if (certHashesList.remove(derOctetStringDigest)) {
                LOG.debug("Cert {} present in timestamp", (Object)certificateToken.getAbbreviation());
                continue;
            }
            LOG.debug("Cert {} not present in timestamp", (Object)certificateToken.getAbbreviation());
        }
        if (!certHashesList.isEmpty()) {
            List<CertificateToken> allCertificates = this.signature.getCompleteCertificateSource().getCertificates();
            for (CertificateToken certificateToken : allCertificates) {
                byte[] digest = certificateToken.getDigest(hashIndexDigestAlgorithm);
                DEROctetString derOctetStringDigest = new DEROctetString(digest);
                if (!certHashesList.remove(derOctetStringDigest)) continue;
                LOG.warn("ats-hash-index attribute contains certificate '{}' present outside SignedData.certificates", (Object)certificateToken.getAbbreviation());
            }
            if (certHashesList.isEmpty()) {
                atsHashIndexStatus.addErrorMessage("ats-hash-index attribute contains certificates present outside of SignedData.certificates.");
            } else {
                LOG.warn("{} attribute(s) hash in Cert Hashes has not been found in document attributes: {}", (Object)certHashesList.size(), (Object)certHashesList);
                atsHashIndexStatus.addErrorMessage("Some ats-hash-index attribute certificates have not been found in document attributes.");
            }
        }
        return certHashes;
    }

    private ASN1Sequence getCRLsHashIndex(DigestAlgorithm hashIndexDigestAlgorithm) {
        ASN1EncodableVector crlsHashIndex = new ASN1EncodableVector();
        CMS cms = this.signature.getCMS();
        Collection<X509CRLHolder> crls = cms.getCRLs().getMatches(null);
        for (X509CRLHolder x509CRLHolder : crls) {
            try {
                this.digestAndAddToList(crlsHashIndex, x509CRLHolder.getEncoded(), hashIndexDigestAlgorithm);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to read CRL. Reason : %s", e.getMessage()), e);
            }
        }
        Collection<?> ocspResponses = cms.getOcspResponseStore().getMatches(null);
        for (Object object : ocspResponses) {
            try {
                if (!(object instanceof ASN1Sequence)) continue;
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                DEROctetString ocspResponseDigest = this.getOcspResponseDigest(otherRevocationInfoMatch.getEncoded(), CMSObjectIdentifiers.id_ri_ocsp_response, hashIndexDigestAlgorithm);
                crlsHashIndex.add(ocspResponseDigest);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to read OCSP Basic. Reason : %s", e.getMessage()), e);
            }
        }
        Collection<?> collection = cms.getOcspBasicStore().getMatches(null);
        for (Object object : collection) {
            try {
                if (!(object instanceof ASN1Sequence)) continue;
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                DEROctetString ocspResponseDigest = this.getOcspResponseDigest(otherRevocationInfoMatch.getEncoded(), OCSPObjectIdentifiers.id_pkix_ocsp_basic, hashIndexDigestAlgorithm);
                crlsHashIndex.add(ocspResponseDigest);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to read OCSP Basic. Reason : %s", e.getMessage()), e);
            }
        }
        return new DERSequence(crlsHashIndex);
    }

    private void digestAndAddToList(ASN1EncodableVector crlsHashIndex, byte[] encoded, DigestAlgorithm hashIndexDigestAlgorithm) {
        byte[] digest = DSSUtils.digest(hashIndexDigestAlgorithm, encoded);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to crlsHashIndex with hash {}", (Object)Utils.toHex(digest));
        }
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        crlsHashIndex.add(derOctetStringDigest);
    }

    private ASN1Sequence getVerifiedCRLsHashIndex(ASN1Sequence timestampHashIndex, DigestAlgorithm hashIndexDigestAlgorithm, ArchiveTimestampHashIndexStatus atsHashIndexStatus) {
        ASN1Sequence crlHashes = CAdESUtils.getCRLHashIndex(timestampHashIndex);
        List<DEROctetString> crlHashesList = DSSASN1Utils.getDEROctetStrings(crlHashes);
        this.findCRLMatches(crlHashesList, hashIndexDigestAlgorithm, this.signature.getCRLSource().getCMSSignedDataRevocationBinaries(), this.signature.getOCSPSource().getCMSSignedDataRevocationBinaries(), true);
        if (!crlHashesList.isEmpty()) {
            this.findCRLMatches(crlHashesList, hashIndexDigestAlgorithm, this.signature.getCompleteCRLSource().getAllRevocationBinaries(), this.signature.getCompleteOCSPSource().getAllRevocationBinaries(), false);
            if (crlHashesList.isEmpty()) {
                atsHashIndexStatus.addErrorMessage("ats-hash-index attribute contains crls present outside of SignedData.crls.");
            } else {
                LOG.warn("{} attribute(s) hash in CRL Hashes has not been found in SignedData.crls: {}", (Object)crlHashesList.size(), (Object)crlHashesList);
                atsHashIndexStatus.addErrorMessage("Some ats-hash-index attribute crls have not been found in document attributes.");
            }
        }
        return crlHashes;
    }

    private void findCRLMatches(List<DEROctetString> crlHashesList, DigestAlgorithm hashIndexDigestAlgorithm, List<EncapsulatedRevocationTokenIdentifier<CRL>> crlBinaries, List<EncapsulatedRevocationTokenIdentifier<OCSP>> ocspBinaries, boolean cmsSignedDataMode) {
        for (EncapsulatedRevocationTokenIdentifier<CRL> encapsulatedRevocationTokenIdentifier : crlBinaries) {
            byte[] digest = encapsulatedRevocationTokenIdentifier.getDigestValue(hashIndexDigestAlgorithm);
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            if (!crlHashesList.remove(derOctetStringDigest) || cmsSignedDataMode) continue;
            LOG.warn("ats-hash-index attribute contains CRL '{}' present outside SignedData.crls", (Object)encapsulatedRevocationTokenIdentifier.getDSSId().asXmlId());
        }
        for (EncapsulatedRevocationTokenIdentifier<Revocation> encapsulatedRevocationTokenIdentifier : ocspBinaries) {
            OCSPResponseBinary binary = (OCSPResponseBinary)encapsulatedRevocationTokenIdentifier;
            ASN1ObjectIdentifier objectIdentifier = binary.getAsn1ObjectIdentifier();
            if (OCSPObjectIdentifiers.id_pkix_ocsp_basic.equals(objectIdentifier)) {
                DEROctetString basicResponseDigest = this.getOcspResponseDigest(binary.getBasicOCSPRespContent(), objectIdentifier, hashIndexDigestAlgorithm);
                if (!crlHashesList.remove(basicResponseDigest) || cmsSignedDataMode) continue;
                LOG.warn("ats-hash-index attribute contains OCSP '{}' present outside SignedData.crls", (Object)binary.getDSSId().asXmlId());
                continue;
            }
            if (objectIdentifier == null) {
                objectIdentifier = OCSPObjectIdentifiers.id_pkix_ocsp_response;
            }
            DEROctetString fullBinaryDigest = this.getOcspResponseDigest(binary.getBinaries(), objectIdentifier, hashIndexDigestAlgorithm);
            DEROctetString basicResponseDigest = this.getOcspResponseDigest(binary.getBasicOCSPRespContent(), objectIdentifier, hashIndexDigestAlgorithm);
            if (!crlHashesList.remove(fullBinaryDigest) && !crlHashesList.remove(basicResponseDigest) || cmsSignedDataMode) continue;
            LOG.warn("ats-hash-index attribute contains OCSP '{}' present outside SignedData.crls", (Object)binary.getDSSId().asXmlId());
        }
    }

    private DEROctetString getOcspResponseDigest(byte[] binaries, ASN1ObjectIdentifier objectIdentifier, DigestAlgorithm digestAlgorithm) {
        byte[] encoded = CAdESUtils.getSignedDataEncodedOCSPResponse(binaries, objectIdentifier);
        byte[] digest = DSSUtils.digest(digestAlgorithm, encoded);
        return new DEROctetString(digest);
    }

    private void handleRevocationEncoded(List<DEROctetString> crlHashesList, byte[] revocationEncoded, DigestAlgorithm hashIndexDigestAlgorithm) {
        byte[] digest = DSSUtils.digest(hashIndexDigestAlgorithm, revocationEncoded);
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        if (crlHashesList.remove(derOctetStringDigest)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL/OCSP present in timestamp {}", (Object)DSSUtils.toHex(derOctetStringDigest.getOctets()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("CRL/OCSP not present in timestamp {}", (Object)DSSUtils.toHex(derOctetStringDigest.getOctets()));
        }
    }

    private ASN1Sequence getUnsignedAttributesHashIndex(SignerInformation signerInformation, ASN1ObjectIdentifier atsHashIndexVersionIdentifier, DigestAlgorithm hashIndexDigestAlgorithm) {
        ASN1EncodableVector unsignedAttributesHashIndex = new ASN1EncodableVector();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            List<DEROctetString> attributeDerOctetStringHashes = this.getAttributeDerOctetStringHashes(attribute, atsHashIndexVersionIdentifier, hashIndexDigestAlgorithm);
            for (DEROctetString derOctetStringDigest : attributeDerOctetStringHashes) {
                unsignedAttributesHashIndex.add(derOctetStringDigest);
            }
        }
        return new DERSequence(unsignedAttributesHashIndex);
    }

    private ASN1Sequence getVerifiedUnsignedAttributesHashIndex(SignerInformation signerInformation, ASN1Sequence timestampHashIndex, ASN1ObjectIdentifier atsHashIndexVersionIdentifier, DigestAlgorithm hashIndexDigestAlgorithm, ArchiveTimestampHashIndexStatus atsHashIndexStatus) {
        ASN1Sequence unsignedAttributesHashes = CAdESUtils.getUnsignedAttributesHashIndex(timestampHashIndex);
        List<DEROctetString> timestampUnsignedAttributesHashesList = DSSASN1Utils.getDEROctetStrings(unsignedAttributesHashes);
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            List<DEROctetString> attributeDerOctetStringHashes = this.getAttributeDerOctetStringHashes(attribute, atsHashIndexVersionIdentifier, hashIndexDigestAlgorithm);
            for (DEROctetString derOctetStringDigest : attributeDerOctetStringHashes) {
                ASN1ObjectIdentifier attrType = attribute.getAttrType();
                if (timestampUnsignedAttributesHashesList.remove(derOctetStringDigest)) {
                    LOG.debug("Attribute {} present in timestamp", (Object)attrType.getId());
                    continue;
                }
                LOG.debug("Attribute {} not present in timestamp", (Object)attrType.getId());
            }
        }
        if (!timestampUnsignedAttributesHashesList.isEmpty()) {
            LOG.warn("{} attribute(s) hash in Timestamp has not been found in unsignedAttrs: {}", (Object)timestampUnsignedAttributesHashesList.size(), (Object)timestampUnsignedAttributesHashesList);
            atsHashIndexStatus.addErrorMessage("Some ats-hash-index attribute entries have not been found in unsignedAttrs.");
        }
        return unsignedAttributesHashes;
    }

    private List<DEROctetString> getAttributeDerOctetStringHashes(Attribute attribute, ASN1ObjectIdentifier atsHashIndexVersionIdentifier, DigestAlgorithm hashIndexDigestAlgorithm) {
        List<byte[]> octets = CAdESUtils.getOctetStringForAtsHashIndex(attribute, atsHashIndexVersionIdentifier);
        if (Utils.isCollectionNotEmpty(octets)) {
            ArrayList<DEROctetString> derOctetStrings = new ArrayList<DEROctetString>();
            for (byte[] bytes : octets) {
                byte[] digest = DSSUtils.digest(hashIndexDigestAlgorithm, bytes);
                derOctetStrings.add(new DEROctetString(digest));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Digest string [{}] has been added to the hash table", (Object)Utils.toHex(digest));
            }
            return derOctetStrings;
        }
        return Collections.emptyList();
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(ASN1Sequence atsHashIndexValue) {
        return DSSASN1Utils.getAlgorithmIdentifier(atsHashIndexValue);
    }

    private AlgorithmIdentifier getHashIndexDigestAlgorithmIdentifier(DigestAlgorithm hashIndexDigestAlgorithm) {
        if (hashIndexDigestAlgorithm.getOid().equals(CAdESUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO.getOid())) {
            return null;
        }
        return DSSASN1Utils.getAlgorithmIdentifier(hashIndexDigestAlgorithm);
    }

    public DSSMessageDigest getArchiveTimestampV3MessageImprint(SignerInformation signerInformation, Attribute atsHashIndexAttribute, DSSDocument originalDocument, DigestAlgorithm digestAlgorithm) {
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(digestAlgorithm);
        byte[] bytes = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Archive Timestamp Data v3 is:");
        }
        bytes = this.getEncodedContentType(this.signature.getCMS());
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("eContentType={}", bytes != null ? (Object)Utils.toHex(bytes) : bytes);
        }
        bytes = originalDocument.getDigestValue(digestAlgorithm);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("signedDataDigest={}", bytes != null ? (Object)Utils.toHex(bytes) : bytes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("encodedFields:");
        }
        this.writeSignedFields(signerInformation, digestCalculator);
        if (LOG.isDebugEnabled()) {
            LOG.debug("encodedFields end");
        }
        bytes = this.getAtsHashIndexAttributeEncoding(atsHashIndexAttribute);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("encodedAtsHashIndex={}", bytes != null ? (Object)Utils.toHex(bytes) : bytes);
        }
        return digestCalculator.getMessageDigest(digestAlgorithm);
    }

    private byte[] getEncodedContentType(CMS cms) {
        return DSSASN1Utils.getDEREncoded(this.signature.getCMS().getSignedContentType());
    }

    private void writeSignedFields(SignerInformation signerInformation, DSSMessageDigestCalculator digestCalculator) {
        byte[] bytes = null;
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        ASN1Integer version = signerInfo.getVersion();
        bytes = DSSASN1Utils.getDEREncoded(version);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields Version={}", (Object)Utils.toBase64(bytes));
        }
        SignerIdentifier sid = signerInfo.getSID();
        bytes = DSSASN1Utils.getDEREncoded(sid);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields Sid={}", (Object)Utils.toBase64(bytes));
        }
        AlgorithmIdentifier digestAlgorithm = signerInfo.getDigestAlgorithm();
        bytes = DSSASN1Utils.getDEREncoded(digestAlgorithm);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields DigestAlgorithm={}", (Object)Utils.toBase64(bytes));
        }
        DERTaggedObject signedAttributes = CAdESUtils.getDERSignedAttributes(signerInformation);
        bytes = DSSASN1Utils.getDEREncoded(signedAttributes);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields SignedAttributes={}", (Object)Utils.toBase64(bytes));
        }
        AlgorithmIdentifier digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        bytes = DSSASN1Utils.getDEREncoded(digestEncryptionAlgorithm);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields DigestEncryptionAlgorithm={}", (Object)Utils.toBase64(bytes));
        }
        ASN1OctetString encryptedDigest = signerInfo.getEncryptedDigest();
        bytes = DSSASN1Utils.getDEREncoded(encryptedDigest);
        digestCalculator.update(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields EncryptedDigest={}", (Object)Utils.toBase64(bytes));
        }
    }

    private byte[] getAtsHashIndexAttributeEncoding(Attribute atsHashIndexAttribute) {
        ASN1Encodable attrValue = DSSASN1Utils.getAsn1Encodable(atsHashIndexAttribute);
        if (attrValue != null) {
            return DSSASN1Utils.getDEREncoded(attrValue);
        }
        LOG.warn("Invalid ats-hash-table-index attribute encoding! The value is skipped.");
        return DSSUtils.EMPTY_BYTE_ARRAY;
    }
}

