/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class CRLValidity
implements Serializable {
    private static final long serialVersionUID = -3382192356286810341L;
    private final CRLBinary crlBinary;
    private String url;
    private boolean onlyUserCerts;
    private boolean onlyCaCerts;
    private ReasonFlags onlySomeReasonFlags;
    private boolean indirectCrl;
    private boolean onlyAttributeCerts;
    private boolean crlSignKeyUsage = false;
    private boolean issuerX509PrincipalMatches = false;
    private boolean signatureIntact = false;
    private String signatureInvalidityReason;
    private SignatureAlgorithm signatureAlgorithm;
    private CertificateToken issuerToken = null;
    private Collection<String> criticalExtensionsOid;
    private Date expiredCertsOnCRL;
    private Date nextUpdate;
    private Date thisUpdate;

    public CRLValidity(CRLBinary crlBinary) {
        Objects.requireNonNull(crlBinary, "CRLBinary cannot be null!");
        this.crlBinary = crlBinary;
    }

    public CRLBinary getCrlBinary() {
        return this.crlBinary;
    }

    public byte[] getDerEncoded() {
        return this.crlBinary.getBinaries();
    }

    public InputStream toCRLInputStream() {
        return new ByteArrayInputStream(this.getDerEncoded());
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Date getExpiredCertsOnCRL() {
        return this.expiredCertsOnCRL;
    }

    public void setExpiredCertsOnCRL(Date expiredCertsOnCRL) {
        this.expiredCertsOnCRL = expiredCertsOnCRL;
    }

    public boolean isIssuerX509PrincipalMatches() {
        return this.issuerX509PrincipalMatches;
    }

    public void setIssuerX509PrincipalMatches(boolean issuerX509PrincipalMatches) {
        this.issuerX509PrincipalMatches = issuerX509PrincipalMatches;
    }

    public boolean isSignatureIntact() {
        return this.signatureIntact;
    }

    public void setSignatureIntact(boolean signatureIntact) {
        this.signatureIntact = signatureIntact;
    }

    public boolean isCrlSignKeyUsage() {
        return this.crlSignKeyUsage;
    }

    public void setCrlSignKeyUsage(boolean crlSignKeyUsage) {
        this.crlSignKeyUsage = crlSignKeyUsage;
    }

    public CertificateToken getIssuerToken() {
        return this.issuerToken;
    }

    public void setIssuerToken(CertificateToken issuerToken) {
        this.issuerToken = issuerToken;
    }

    public String getSignatureInvalidityReason() {
        return this.signatureInvalidityReason;
    }

    public void setSignatureInvalidityReason(String signatureInvalidityReason) {
        this.signatureInvalidityReason = signatureInvalidityReason;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOnlyUserCerts(boolean onlyUserCerts) {
        this.onlyUserCerts = onlyUserCerts;
    }

    public void setOnlyCaCerts(boolean onlyCaCerts) {
        this.onlyCaCerts = onlyCaCerts;
    }

    public void setReasonFlags(ReasonFlags reasonFlags) {
        this.onlySomeReasonFlags = reasonFlags;
    }

    public void setIndirectCrl(boolean indirectCrl) {
        this.indirectCrl = indirectCrl;
    }

    public void setOnlyAttributeCerts(boolean onlyAttributeCerts) {
        this.onlyAttributeCerts = onlyAttributeCerts;
    }

    public boolean areCriticalExtensionsOidNotEmpty() {
        return this.criticalExtensionsOid != null && !this.criticalExtensionsOid.isEmpty();
    }

    public void setCriticalExtensionsOid(Collection<String> criticalExtensionsOid) {
        this.criticalExtensionsOid = criticalExtensionsOid;
    }

    public boolean isValid() {
        return this.issuerX509PrincipalMatches && this.signatureIntact && this.crlSignKeyUsage && !this.isUnknownCriticalExtension();
    }

    public boolean isUnknownCriticalExtension() {
        return this.areCriticalExtensionsOidNotEmpty() && (this.onlyAttributeCerts && this.onlyCaCerts && this.onlyUserCerts && this.indirectCrl || this.onlySomeReasonFlags != null || this.url == null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CRLValidity)) {
            return false;
        }
        CRLValidity that = (CRLValidity)o;
        if (this.onlyUserCerts != that.onlyUserCerts) {
            return false;
        }
        if (this.onlyCaCerts != that.onlyCaCerts) {
            return false;
        }
        if (this.indirectCrl != that.indirectCrl) {
            return false;
        }
        if (this.onlyAttributeCerts != that.onlyAttributeCerts) {
            return false;
        }
        if (this.crlSignKeyUsage != that.crlSignKeyUsage) {
            return false;
        }
        if (this.issuerX509PrincipalMatches != that.issuerX509PrincipalMatches) {
            return false;
        }
        if (this.signatureIntact != that.signatureIntact) {
            return false;
        }
        if (!Objects.equals(this.crlBinary, that.crlBinary)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.onlySomeReasonFlags, that.onlySomeReasonFlags)) {
            return false;
        }
        if (!Objects.equals(this.signatureInvalidityReason, that.signatureInvalidityReason)) {
            return false;
        }
        if (this.signatureAlgorithm != that.signatureAlgorithm) {
            return false;
        }
        if (!Objects.equals(this.issuerToken, that.issuerToken)) {
            return false;
        }
        if (!Objects.equals(this.criticalExtensionsOid, that.criticalExtensionsOid)) {
            return false;
        }
        if (!Objects.equals(this.expiredCertsOnCRL, that.expiredCertsOnCRL)) {
            return false;
        }
        if (!Objects.equals(this.nextUpdate, that.nextUpdate)) {
            return false;
        }
        return Objects.equals(this.thisUpdate, that.thisUpdate);
    }

    public int hashCode() {
        int result = this.crlBinary != null ? this.crlBinary.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.onlyUserCerts ? 1 : 0);
        result = 31 * result + (this.onlyCaCerts ? 1 : 0);
        result = 31 * result + (this.onlySomeReasonFlags != null ? this.onlySomeReasonFlags.hashCode() : 0);
        result = 31 * result + (this.indirectCrl ? 1 : 0);
        result = 31 * result + (this.onlyAttributeCerts ? 1 : 0);
        result = 31 * result + (this.crlSignKeyUsage ? 1 : 0);
        result = 31 * result + (this.issuerX509PrincipalMatches ? 1 : 0);
        result = 31 * result + (this.signatureIntact ? 1 : 0);
        result = 31 * result + (this.signatureInvalidityReason != null ? this.signatureInvalidityReason.hashCode() : 0);
        result = 31 * result + (this.signatureAlgorithm != null ? this.signatureAlgorithm.hashCode() : 0);
        result = 31 * result + (this.issuerToken != null ? this.issuerToken.hashCode() : 0);
        result = 31 * result + (this.criticalExtensionsOid != null ? this.criticalExtensionsOid.hashCode() : 0);
        result = 31 * result + (this.expiredCertsOnCRL != null ? this.expiredCertsOnCRL.hashCode() : 0);
        result = 31 * result + (this.nextUpdate != null ? this.nextUpdate.hashCode() : 0);
        result = 31 * result + (this.thisUpdate != null ? this.thisUpdate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CRLValidity{DSS ID=" + this.crlBinary.asXmlId() + ", issuerX509PrincipalMatches=" + this.issuerX509PrincipalMatches + ", signatureIntact=" + this.signatureIntact + ", crlSignKeyUsage=" + this.crlSignKeyUsage + ", unknownCriticalExtension=" + this.isUnknownCriticalExtension() + ", issuerToken=" + this.issuerToken + ", signatureInvalidityReason='" + this.signatureInvalidityReason + '\'' + '}';
    }
}

