/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.OrphanCertificateTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlAbstractToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EvidenceRecordWrapper {
    private final XmlEvidenceRecord evidenceRecord;

    public EvidenceRecordWrapper(XmlEvidenceRecord evidenceRecord) {
        Objects.requireNonNull(evidenceRecord, "XmlEvidenceRecord cannot be null!");
        this.evidenceRecord = evidenceRecord;
    }

    public String getId() {
        return this.evidenceRecord.getId();
    }

    public boolean isEvidenceRecordDuplicated() {
        return this.evidenceRecord.isDuplicated() != null && this.evidenceRecord.isDuplicated() != false;
    }

    public String getFilename() {
        return this.evidenceRecord.getDocumentName();
    }

    public List<XmlDigestMatcher> getDigestMatchers() {
        return this.evidenceRecord.getDigestMatchers();
    }

    public TimestampWrapper getFirstTimestamp() {
        List<TimestampWrapper> timestampList = this.getTimestampList();
        if (timestampList != null && !timestampList.isEmpty()) {
            return timestampList.get(0);
        }
        return null;
    }

    public List<TimestampWrapper> getTimestampList() {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List<XmlFoundTimestamp> timestamps = this.evidenceRecord.getEvidenceRecordTimestamps();
        for (XmlFoundTimestamp xmlFoundTimestamp : timestamps) {
            tsps.add(new TimestampWrapper(xmlFoundTimestamp.getTimestamp()));
        }
        return tsps;
    }

    public List<String> getTimestampIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        List<TimestampWrapper> timestamps = this.getTimestampList();
        if (timestamps != null) {
            for (TimestampWrapper tsp : timestamps) {
                result.add(tsp.getId());
            }
        }
        return result;
    }

    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(this.evidenceRecord.getFoundCertificates());
    }

    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(this.evidenceRecord.getFoundRevocations());
    }

    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return this.evidenceRecord.getType();
    }

    public EvidenceRecordOrigin getOrigin() {
        return this.evidenceRecord.getOrigin();
    }

    public boolean isEmbedded() {
        return this.evidenceRecord.isEmbedded() != null && this.evidenceRecord.isEmbedded() != false;
    }

    public SignatureWrapper getParent() {
        XmlSignature parent = this.evidenceRecord.getParent();
        if (parent != null) {
            return new SignatureWrapper(parent);
        }
        return null;
    }

    public EvidenceRecordIncorporationType getIncorporationType() {
        return this.evidenceRecord.getIncorporationType();
    }

    public boolean isStructuralValidationValid() {
        return this.evidenceRecord.getStructuralValidation() != null && this.evidenceRecord.getStructuralValidation().isValid();
    }

    public List<String> getStructuralValidationMessages() {
        XmlStructuralValidation structuralValidation = this.evidenceRecord.getStructuralValidation();
        if (structuralValidation != null) {
            return structuralValidation.getMessages();
        }
        return Collections.emptyList();
    }

    public List<XmlTimestampedObject> getCoveredObjects() {
        return this.evidenceRecord.getTimestampedObjects();
    }

    public List<SignatureWrapper> getCoveredSignatures() {
        ArrayList<SignatureWrapper> signatures = new ArrayList<SignatureWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.SIGNATURE);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlSignature) {
                signatures.add(new SignatureWrapper((XmlSignature)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.SIGNATURE}));
        }
        return signatures;
    }

    public List<CertificateWrapper> getCoveredCertificates() {
        ArrayList<CertificateWrapper> certificates = new ArrayList<CertificateWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.CERTIFICATE);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlCertificate) {
                certificates.add(new CertificateWrapper((XmlCertificate)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.CERTIFICATE}));
        }
        return certificates;
    }

    public List<RevocationWrapper> getCoveredRevocations() {
        ArrayList<RevocationWrapper> revocations = new ArrayList<RevocationWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.REVOCATION);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlRevocation) {
                revocations.add(new RevocationWrapper((XmlRevocation)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.REVOCATION}));
        }
        return revocations;
    }

    public List<TimestampWrapper> getCoveredTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.TIMESTAMP);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlTimestamp) {
                timestamps.add(new TimestampWrapper((XmlTimestamp)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.TIMESTAMP}));
        }
        return timestamps;
    }

    public List<EvidenceRecordWrapper> getCoveredEvidenceRecords() {
        ArrayList<EvidenceRecordWrapper> evidenceRecords = new ArrayList<EvidenceRecordWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.EVIDENCE_RECORD);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlEvidenceRecord) {
                evidenceRecords.add(new EvidenceRecordWrapper((XmlEvidenceRecord)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.EVIDENCE_RECORD}));
        }
        return evidenceRecords;
    }

    public List<SignerDataWrapper> getCoveredSignedData() {
        ArrayList<SignerDataWrapper> timestamps = new ArrayList<SignerDataWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.SIGNED_DATA);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlSignerData) {
                timestamps.add(new SignerDataWrapper((XmlSignerData)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.SIGNED_DATA}));
        }
        return timestamps;
    }

    public List<OrphanTokenWrapper> getAllCoveredOrphanTokens() {
        ArrayList<OrphanTokenWrapper> timestampedObjectIds = new ArrayList<OrphanTokenWrapper>();
        timestampedObjectIds.addAll(this.getCoveredOrphanCertificates());
        timestampedObjectIds.addAll(this.getCoveredOrphanRevocations());
        return timestampedObjectIds;
    }

    public List<OrphanCertificateTokenWrapper> getCoveredOrphanCertificates() {
        ArrayList<OrphanCertificateTokenWrapper> orphanCertificates = new ArrayList<OrphanCertificateTokenWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.ORPHAN_CERTIFICATE);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlOrphanCertificateToken) {
                orphanCertificates.add(new OrphanCertificateTokenWrapper((XmlOrphanCertificateToken)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.ORPHAN_CERTIFICATE}));
        }
        return orphanCertificates;
    }

    public List<OrphanRevocationTokenWrapper> getCoveredOrphanRevocations() {
        ArrayList<OrphanRevocationTokenWrapper> orphanRevocations = new ArrayList<OrphanRevocationTokenWrapper>();
        List<XmlAbstractToken> coveredObjectsByCategory = this.getCoveredObjectsByCategory(TimestampedObjectType.ORPHAN_REVOCATION);
        for (XmlAbstractToken token : coveredObjectsByCategory) {
            if (token instanceof XmlOrphanRevocationToken) {
                orphanRevocations.add(new OrphanRevocationTokenWrapper((XmlOrphanRevocationToken)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.ORPHAN_REVOCATION}));
        }
        return orphanRevocations;
    }

    private List<XmlAbstractToken> getCoveredObjectsByCategory(TimestampedObjectType category) {
        ArrayList<XmlAbstractToken> coveredObjectIds = new ArrayList<XmlAbstractToken>();
        for (XmlTimestampedObject coveredObject : this.getCoveredObjects()) {
            if (category != coveredObject.getCategory()) continue;
            coveredObjectIds.add(coveredObject.getToken());
        }
        return coveredObjectIds;
    }

    public List<XmlSignatureScope> getEvidenceRecordScopes() {
        return this.evidenceRecord.getEvidenceRecordScopes();
    }

    public byte[] getBinaries() {
        return this.evidenceRecord.getBase64Encoded();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.evidenceRecord.getDigestAlgoAndValue();
    }
}

