/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPSD2QcInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRoleOfPSP;
import eu.europa.esig.dss.enumerations.RoleOfPspOid;
import java.util.ArrayList;
import java.util.List;

public class PSD2InfoWrapper {
    private final XmlPSD2QcInfo psd2QcInfo;

    public PSD2InfoWrapper(XmlPSD2QcInfo psd2QcInfo) {
        this.psd2QcInfo = psd2QcInfo;
    }

    public List<String> getRoleOfPSPNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlRoleOfPSP> rolesOfPSP = this.psd2QcInfo.getRolesOfPSP();
        for (XmlRoleOfPSP roleOfPSP : rolesOfPSP) {
            result.add(roleOfPSP.getName());
        }
        return result;
    }

    public List<RoleOfPspOid> getRoleOfPSPOids() {
        ArrayList<RoleOfPspOid> result = new ArrayList<RoleOfPspOid>();
        List<XmlRoleOfPSP> rolesOfPSP = this.psd2QcInfo.getRolesOfPSP();
        for (XmlRoleOfPSP roleOfPSP : rolesOfPSP) {
            XmlOID pspOid = roleOfPSP.getOid();
            if (pspOid == null) continue;
            result.add(RoleOfPspOid.fromOid(pspOid.getValue()));
        }
        return result;
    }

    public String getNcaId() {
        return this.psd2QcInfo.getNcaId();
    }

    public String getNcaName() {
        return this.psd2QcInfo.getNcaName();
    }
}

