/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

public enum GeneralNameType {
    OTHER_NAME(0, "otherName"),
    RFC822_NAME(1, "rfc822Name"),
    DNS_NAME(2, "dNSName"),
    X400_ADDRESS(3, "x400Address"),
    DIRECTORY_NAME(4, "directoryName"),
    EDI_PARTY_NAME(5, "ediPartyName"),
    UNIFORM_RESOURCE_IDENTIFIER(6, "uniformResourceIdentifier"),
    IP_ADDRESS(7, "iPAddress"),
    REGISTERED_ID(8, "registeredID");

    private final int index;
    private final String label;

    private GeneralNameType(int index, String label) {
        this.index = index;
        this.label = label;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public static GeneralNameType fromIndex(int index) {
        for (GeneralNameType generalNameType : GeneralNameType.values()) {
            if (index != generalNameType.index) continue;
            return generalNameType;
        }
        return null;
    }

    public static GeneralNameType fromLabel(String label) {
        for (GeneralNameType generalNameType : GeneralNameType.values()) {
            if (!label.equals(generalNameType.label)) continue;
            return generalNameType;
        }
        return null;
    }
}

