/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.digest;

import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.model.DSSMessageDigest;
import java.util.List;

public abstract class AbstractEvidenceRecordRenewalDigestBuilderHelper {
    protected final DefaultEvidenceRecord evidenceRecord;

    protected AbstractEvidenceRecordRenewalDigestBuilderHelper(DefaultEvidenceRecord evidenceRecord) {
        this.evidenceRecord = evidenceRecord;
    }

    protected ArchiveTimeStampChainObject getArchiveTimeStampChainObject(ArchiveTimeStampObject archiveTimeStampObject) {
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = this.evidenceRecord.getArchiveTimeStampSequence();
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : archiveTimeStampSequence) {
            for (ArchiveTimeStampObject archiveTimeStampObject2 : archiveTimeStampChainObject.getArchiveTimeStamps()) {
                if (!archiveTimeStampObject.equals(archiveTimeStampObject2)) continue;
                return archiveTimeStampChainObject;
            }
        }
        throw new IllegalArgumentException("Unable to find a corresponding ArchiveTimeStampChain for the given ArchiveTimeStamp!");
    }

    public abstract DSSMessageDigest buildTimeStampRenewalDigest(ArchiveTimeStampObject var1);

    public abstract DSSMessageDigest buildArchiveTimeStampSequenceDigest(ArchiveTimeStampChainObject var1);

    protected ArchiveTimeStampChainObject getNextArchiveTimeStampChain(ArchiveTimeStampChainObject archiveTimeStampChainObject) {
        int order = archiveTimeStampChainObject.getOrder();
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = this.evidenceRecord.getArchiveTimeStampSequence();
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject2 : archiveTimeStampSequence) {
            if (archiveTimeStampChainObject2.getOrder() != order + 1) continue;
            return archiveTimeStampChainObject2;
        }
        return null;
    }
}

